/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mockServer;

import com.mulesoft.connectivity.mockServer.HttpMockServer;
import org.mockserver.configuration.Configuration;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.MediaType;
import org.mockserver.model.RequestDefinition;
import org.slf4j.event.Level;

public class ProxyEnabledHttpMockServer
extends HttpMockServer {
    private final int proxyPort;
    private ClientAndServer proxyServer;

    public ProxyEnabledHttpMockServer(int mockPort, int proxyPort) {
        super(mockPort);
        this.proxyPort = proxyPort;
    }

    @Override
    public void startServer() {
        super.startServer();
        this.startProxyServer();
    }

    public void startProxyServer() {
        Configuration proxyConfig = Configuration.configuration().logLevel(Level.INFO);
        this.proxyServer = ClientAndServer.startClientAndServer((Configuration)proxyConfig, (Integer[])new Integer[]{this.proxyPort});
    }

    public void configureProxyForwarding(String proxyResponseBody) {
        this.proxyServer.when((RequestDefinition)HttpRequest.request()).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withHeader("X-Proxy-Used", new String[]{"true"}).withHeader("X-Proxy-Port", new String[]{String.valueOf(this.proxyPort)}).withHeader("Via", new String[]{"MockServer-Proxy/" + this.proxyPort}).withHeader("X-Proxy-Intercepted", new String[]{"true"}).withHeader("X-Forwarded-For", new String[]{"127.0.0.1"}).withBody(proxyResponseBody).withContentType(MediaType.APPLICATION_JSON));
    }

    @Override
    public void stopServer() {
        super.stopServer();
        if (this.proxyServer != null) {
            this.proxyServer.stop();
        }
    }
}

