/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation;

import com.mulesoft.connectivity.validation.ValidatableType;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.location.Location;
import org.mule.weave.v2.api.tooling.ts.DWType;

public final class Validatable<E> {
    private final E element;
    private final EnumSet<ValidatableType> types;
    private final EnumSet<ValidatableType> context;
    private final @Nullable Validatable<?> parent;
    private final @Nullable String name;
    private final @Nullable Location location;

    private Validatable(E element, EnumSet<ValidatableType> types, @Nullable Location location, @Nullable String name, EnumSet<ValidatableType> context, @Nullable Validatable<?> parent) {
        this.element = element;
        this.types = EnumSet.copyOf(types);
        this.context = EnumSet.copyOf(context);
        this.name = name;
        this.location = location;
        this.parent = parent;
    }

    public E getElement() {
        return this.element;
    }

    public Set<ValidatableType> getTypes() {
        return this.types;
    }

    public boolean hasType(ValidatableType type) {
        return this.types.contains((Object)type);
    }

    public boolean hasAnyType(ValidatableType ... types) {
        for (ValidatableType t : types) {
            if (!this.types.contains((Object)t)) continue;
            return true;
        }
        return false;
    }

    public Set<ValidatableType> getContext() {
        return this.context;
    }

    public boolean hasContext(ValidatableType context) {
        return this.context.contains((Object)context);
    }

    public boolean hasAnyContext(ValidatableType ... contexts) {
        for (ValidatableType c : contexts) {
            if (!this.context.contains((Object)c)) continue;
            return true;
        }
        return false;
    }

    public @Nullable Validatable<?> getParent() {
        return this.parent;
    }

    public String toString() {
        return "Validatable{element=" + this.element.getClass().getSimpleName() + ", name=" + this.name + ", types=" + String.valueOf(this.types) + ", context=" + String.valueOf(this.context) + ", path=" + this.pathDescription() + "}";
    }

    public String pathDescription() {
        Stream<Validatable<?>> path = this.getPath();
        return path.map(p -> {
            if (p.name != null) {
                return p.name;
            }
            if (!p.types.isEmpty()) {
                return ((ValidatableType)((Object)((Object)p.types.iterator().next()))).toString();
            }
            return p.element.getClass().getSimpleName();
        }).collect(Collectors.joining("."));
    }

    public Stream<Validatable<?>> getPath() {
        ArrayDeque path = new ArrayDeque();
        path.add(this);
        for (Validatable<?> v = this.getParent(); v != null; v = v.getParent()) {
            path.addFirst(v);
        }
        return path.stream();
    }

    public String stringPath() {
        return this.getPath().dropWhile(p -> p.hasAnyType(ValidatableType.OPERATION, ValidatableType.CONNECTOR, ValidatableType.EXECUTOR, ValidatableType.TRIGGER)).map(Validatable::pathComponentName).filter(Objects::nonNull).collect(Collectors.joining(".")).replace(".[]", "[]");
    }

    private static @Nullable String pathComponentName(Validatable<?> v) {
        if (v.hasType(ValidatableType.INPUT)) {
            return "input";
        }
        if (v.hasType(ValidatableType.OUTPUT)) {
            return "output";
        }
        return v.name;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Location getLocation() {
        if (this.location == null) {
            E e = this.element;
            if (e instanceof DWType) {
                DWType t = (DWType)e;
                return t.getLocation();
            }
            throw new IllegalStateException("This validatable element (" + String.valueOf(this) + ") doesn't have a location");
        }
        return this.location;
    }

    public static class Builder<E> {
        private final E element;
        private final EnumSet<ValidatableType> types = EnumSet.noneOf(ValidatableType.class);
        private final EnumSet<ValidatableType> context = EnumSet.noneOf(ValidatableType.class);
        private @Nullable Validatable<?> parent;
        private @Nullable String name;
        private @Nullable Location location;

        Builder(E element) {
            this.element = Objects.requireNonNull(element, "Element cannot be null");
        }

        public Builder<E> withType(ValidatableType type) {
            this.addWithImplied(this.types, type);
            return this;
        }

        public Builder<E> withTypes(Collection<ValidatableType> types) {
            types.forEach(this::withType);
            return this;
        }

        public Builder<E> withContext(ValidatableType contextType) {
            this.context.add(contextType);
            return this;
        }

        public Builder<E> withContext(Collection<ValidatableType> contexts) {
            this.context.addAll(contexts);
            return this;
        }

        public Builder<E> withParent(Validatable<?> parent) {
            this.parent = parent;
            return this;
        }

        public Builder<E> withName(String name) {
            this.name = name;
            return this;
        }

        public Builder<E> withLocation(Location location) {
            this.location = location;
            return this;
        }

        public Validatable<E> build() {
            return new Validatable<E>(this.element, this.types, this.location, this.name, this.context, this.parent);
        }

        private void addWithImplied(EnumSet<ValidatableType> set, ValidatableType type) {
            if (set.add(type)) {
                for (ValidatableType implied : type.getImplied()) {
                    this.addWithImplied(set, implied);
                }
            }
        }
    }
}

