/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation.rules;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Message;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.List;
import org.mule.weave.v2.api.tooling.ts.BooleanType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.FunctionType;
import org.mule.weave.v2.api.tooling.ts.IntersectionType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.UnionType;
import org.mule.weave.v2.ts.ReferenceType;

public class ExecutorRule
extends Rule<DWType> {
    public static final String WRONG_EXECUTOR_RETURN_TYPE_ERROR = "Executor function return type must be of Result type";

    public ExecutorRule() {
        super(DWType.class, ValidatableType.EXECUTOR);
    }

    @Override
    protected void validate(Validatable<DWType> validatable, ValidationContext ctx) {
        DWType executor = validatable.getElement();
        DWType valueType = TypeUtils.resolveReferenceType((DWType)executor);
        if (!(valueType instanceof FunctionType)) {
            ctx.addError(executor.getLocation(), "Invalid type for property 'executor'. Expected: Function; Actual: " + String.valueOf(valueType), "connector");
            return;
        }
        FunctionType executorFunction = (FunctionType)valueType;
        if (executorFunction.getParameters().length != 2) {
            ctx.addError(executor.getLocation(), "Invalid type for property 'executor'. Expected an executor function but got " + String.valueOf(valueType), "connector");
            return;
        }
        DWType resultType = TypeUtils.resolveReferenceType((DWType)executorFunction.getReturnType());
        if (!(resultType instanceof UnionType)) {
            ctx.addError(executor.getLocation(), WRONG_EXECUTOR_RETURN_TYPE_ERROR, "connector");
            return;
        }
        DWType[] unionWeaveTypes = ((UnionType)resultType).unionOf();
        if (unionWeaveTypes.length != 2) {
            ctx.addError(resultType.getLocation(), WRONG_EXECUTOR_RETURN_TYPE_ERROR, "connector");
            return;
        }
        DWType successType = TypeUtils.resolveReferenceType((DWType)unionWeaveTypes[0]);
        if (!this.isResultSuccess(successType)) {
            ctx.addError(resultType.getLocation(), WRONG_EXECUTOR_RETURN_TYPE_ERROR, "connector");
            return;
        }
        DWType failureType = TypeUtils.resolveReferenceType((DWType)unionWeaveTypes[1]);
        if (!this.isResultFailure(failureType)) {
            ctx.addError(resultType.getLocation(), WRONG_EXECUTOR_RETURN_TYPE_ERROR, "connector");
            return;
        }
        DWType inputType = executorFunction.getParameters()[0].getType();
        DWType outputType = TypeUtils.requireObjectPropertyType((DWType)resultType, (String)"value");
        Message input = Message.input(inputType);
        Message output = Message.output(outputType, inputType);
        ctx.queue(ctx.validatable(input).withType(ValidatableType.INPUT).withLocation(inputType.getLocation()).build());
        ctx.queue(ctx.validatable(output).withType(ValidatableType.OUTPUT).withLocation(outputType.getLocation()).build());
    }

    private boolean isResultFailure(DWType failureType) {
        if (failureType instanceof UnionType) {
            for (DWType weaveType : ((UnionType)failureType).unionOf()) {
                if (weaveType instanceof ReferenceType) {
                    weaveType = TypeUtils.resolveReferenceType((DWType)weaveType);
                }
                if (this.isResultFailureObject(weaveType)) continue;
                return false;
            }
            return true;
        }
        return this.isResultFailureObject(failureType);
    }

    private boolean isResultFailureObject(DWType type) {
        if (!(type instanceof ObjectType)) {
            return false;
        }
        ObjectType objectType = (ObjectType)type;
        List<KeyValuePairType> properties = List.of(objectType.getProperties());
        if (properties.size() != 2 || !(DWTypeUtils.getFieldByName((ObjectType)objectType, (String)"success").map(KeyValuePairType::getValue).orElse(null) instanceof BooleanType) || !(DWTypeUtils.getFieldByName((ObjectType)objectType, (String)"error").map(KeyValuePairType::getValue).orElse(null) instanceof IntersectionType)) {
            return false;
        }
        IntersectionType errorType = (IntersectionType)((KeyValuePairType)DWTypeUtils.getFieldByName((ObjectType)objectType, (String)"error").orElseThrow()).getValue();
        return TypeUtils.getObjectProperty((DWType)errorType, (String)"description").map(KeyValuePairType::getValue).orElse(null) instanceof UnionType && TypeUtils.getObjectProperty((DWType)errorType, (String)"value").isPresent() && TypeUtils.getObjectProperty((DWType)errorType, (String)"kind").isPresent() && TypeUtils.getObjectProperty((DWType)errorType, (String)"categories").isPresent();
    }

    private boolean isResultSuccess(DWType type) {
        if (!(type instanceof ObjectType)) {
            return false;
        }
        ObjectType objectType = (ObjectType)type;
        List<KeyValuePairType> properties = List.of(objectType.getProperties());
        return properties.size() == 2 && DWTypeUtils.getFieldByName((ObjectType)objectType, (String)"success").isPresent() && DWTypeUtils.getFieldByName((ObjectType)objectType, (String)"value").isPresent();
    }
}

