/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation.rules;

import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.Optional;
import org.mule.weave.v2.api.tooling.location.Location;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.IntersectionType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

public class OperationRule
extends Rule<DWType> {
    public OperationRule() {
        super(DWType.class, ValidatableType.OPERATION);
    }

    @Override
    protected void validate(Validatable<DWType> validatable, ValidationContext ctx) {
        DWType weaveType = validatable.getElement();
        Location operationLocation = weaveType.getLocation();
        if (weaveType instanceof IntersectionType) {
            ctx.addWarning(operationLocation, "Skipping validation of operation '" + (String)validatable.getName().orElse(null) + "' because is defined with an intersection type", "connector");
            return;
        }
        if (weaveType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)weaveType;
            Optional maybe = DWTypeUtils.getFieldByName((ObjectType)objectType, (String)"executor");
            maybe.ifPresentOrElse(ex -> ctx.queue(ctx.validatable(ex.getValue()).withType(ValidatableType.EXECUTOR).withName(DWTypeUtils.getKey((KeyValuePairType)ex)).build()), () -> ctx.addError(objectType.getLocation(), "Missing executor property in operation definition", "connector"));
        } else {
            ctx.addError(operationLocation, "Invalid type for operation '" + (String)validatable.getName().orElse(null) + "'. Expected: Operation Actual: " + String.valueOf(weaveType), "connector");
        }
    }
}

