/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation.rules;

import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderArgument;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.validation.ProviderType;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.Arrays;
import java.util.Optional;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.SimpleReferenceType;

public class ProviderReferenceRule
extends Rule<DWType> {
    public ProviderReferenceRule() {
        super(DWType.class);
    }

    @Override
    protected void validate(Validatable<DWType> validatable, ValidationContext ctx) {
        if (validatable.hasContext(ValidatableType.INPUT)) {
            ProviderReferenceRule.validate(validatable, ctx, ProviderType.VALUE_PROVIDER);
        }
        ProviderReferenceRule.validate(validatable, ctx, ProviderType.METADATA_PROVIDER);
    }

    private static void validate(Validatable<DWType> validatable, ValidationContext ctx, ProviderType providerType) {
        DWType type = validatable.getElement();
        (switch (providerType) {
            default -> throw new IncompatibleClassChangeError();
            case ProviderType.VALUE_PROVIDER -> MetadataUtils.getValueProvider((DWType)type);
            case ProviderType.METADATA_PROVIDER -> MetadataUtils.getMetadataProvider((DWType)type);
        }).ifPresent(providerReference -> {
            SimpleReferenceType simpleReferenceType = (SimpleReferenceType)ctx.getProvider(providerType, providerReference.getName());
            if (simpleReferenceType == null) {
                ctx.addError(type.getLocation(), "Cannot find " + providerType.description() + " '" + providerReference.getName() + "'.", "connector");
                return;
            }
            ProviderReferenceRule.validateProviderReference(ctx, type, validatable.stringPath(), providerReference, providerType.description(), simpleReferenceType);
        });
    }

    @Override
    public boolean appliesTo(Validatable<DWType> validatable) {
        return super.appliesTo(validatable) && (validatable.hasContext(ValidatableType.INPUT) || validatable.hasContext(ValidatableType.OUTPUT));
    }

    public static void validateProviderReference(ValidationContext ctx, DWType type, String path, ProviderReference metadataProviderReference, String what, SimpleReferenceType metadataProviderConnector) {
        DWType dWType = Arrays.stream((DWType[])metadataProviderConnector.getTypeParameters().get()).findFirst().get();
        if (!(dWType instanceof ObjectType)) {
            return;
        }
        ObjectType inputMetadataProviderConnector = (ObjectType)dWType;
        Arrays.stream(inputMetadataProviderConnector.getProperties()).filter(p -> !p.isOptionalKey()).forEach(property -> {
            if (metadataProviderReference.getArguments().stream().filter(param -> ProviderReferenceRule.isProviderArgumentFor(property, param)).findFirst().isEmpty()) {
                ctx.addError(type.getLocation(), "Invalid " + what + " reference" + (String)(path.isEmpty() ? "" : " at " + path) + " missing parameter '" + DWTypeUtils.getKey((KeyValuePairType)property) + "'", "InvalidFlowType");
            }
        });
        metadataProviderReference.getArguments().forEach(param -> {
            Optional<KeyValuePairType> maybeProperty = Arrays.stream(inputMetadataProviderConnector.getProperties()).filter(property -> ProviderReferenceRule.isProviderArgumentFor(property, param)).findFirst();
            if (maybeProperty.isEmpty()) {
                ctx.addError(type.getLocation(), "Invalid " + what + " reference" + (String)(path.isEmpty() ? "" : " at " + path) + " parameter '" + String.valueOf(param.getParameterSelector()) + "' does not match to any parameter defined in the " + what + " '" + metadataProviderReference.getName() + "'", "InvalidFlowType");
            }
        });
    }

    private static boolean isProviderArgumentFor(KeyValuePairType parameterDef, ProviderArgument paramValue) {
        if (paramValue.getParameterSelector().getPath().length == 0) {
            return false;
        }
        return paramValue.getParameterSelector().getPath()[0].equals(DWTypeUtils.getKey((KeyValuePairType)parameterDef));
    }
}

