/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation.rules;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Message;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.FunctionType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.TypeParameter;

public class TriggerRule
extends Rule<DWType> {
    public static final List<String> REQUIRED_FIELDS = List.of("name", "displayName", "operation", "strategy", "inputMapper", "initialWatermark");
    public static final String MISSING_PROPERTY_ERROR = "Missing '%s' property in trigger definition";

    public TriggerRule() {
        super(DWType.class, ValidatableType.TRIGGER);
    }

    @Override
    protected void validate(Validatable<DWType> validatable, ValidationContext ctx) {
        DWType dWType = validatable.getElement();
        if (!(dWType instanceof ObjectType)) {
            ctx.addError(validatable.getLocation(), "Invalid type for trigger '" + (String)validatable.getName().orElse(null) + "'. Expected: Trigger; Actual: " + String.valueOf(validatable.getElement()), "connector");
            return;
        }
        ObjectType trigger = (ObjectType)dWType;
        if (!this.validateTriggerRequiredFields(trigger, ctx)) {
            return;
        }
        DWType triggerInputType = TriggerRule.getTriggerInputType(trigger);
        if (triggerInputType == null) {
            return;
        }
        DWType dWType2 = TypeUtils.resolveReferenceType((DWType)triggerInputType);
        if (dWType2 instanceof ObjectType) {
            ObjectType objectType = (ObjectType)dWType2;
            ctx.queue(ctx.validatable(Message.input((DWType)objectType)).withType(ValidatableType.INPUT).build());
        }
    }

    private boolean validateTriggerRequiredFields(ObjectType trigger, ValidationContext ctx) {
        return REQUIRED_FIELDS.stream().allMatch(f -> this.hasRequiredField(trigger, (String)f, ctx));
    }

    private boolean hasRequiredField(ObjectType trigger, String field, ValidationContext ctx) {
        boolean hasField = DWTypeUtils.getFieldByName((ObjectType)trigger, (String)field).isPresent();
        if (!hasField) {
            ctx.addError(trigger.getLocation(), String.format(MISSING_PROPERTY_ERROR, field), "MissingRequiredProperty");
        }
        return hasField;
    }

    public static @Nullable DWType getTriggerInputType(ObjectType trigger) {
        DWType inputMapper = DWTypeUtils.getFieldByName((ObjectType)trigger, (String)"inputMapper").map(KeyValuePairType::getValue).orElse(null);
        if (inputMapper == null) {
            return null;
        }
        DWType inputType = TypeUtils.resolveReferenceType((DWType)((FunctionType)inputMapper).getParameters()[0].getType());
        if (inputType instanceof TypeParameter) {
            DWType operation = DWTypeUtils.requireFieldByName((ObjectType)trigger, (String)"operation").getValue();
            DWType executor = DWTypeUtils.requireFieldByName((ObjectType)((ObjectType)TypeUtils.resolveReferenceType((DWType)operation)), (String)"executor").getValue();
            FunctionType function = (FunctionType)TypeUtils.resolveReferenceType((DWType)executor);
            inputType = TypeUtils.resolveReferenceType((DWType)function.getParameters()[0].getType());
        }
        return inputType;
    }
}

