/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation.rules;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.Locale;
import java.util.Optional;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

public class NamedComponentsRule
extends Rule<DWType> {
    protected final ValidatableType componentToExtract;
    private final String propertyName;
    private final boolean resolve;

    public NamedComponentsRule(ValidatableType validatableType, String propertyName, ValidatableType componentToExtract, boolean resolve) {
        super(DWType.class, validatableType);
        this.componentToExtract = componentToExtract;
        this.propertyName = propertyName;
        this.resolve = resolve;
    }

    @Override
    protected void validate(Validatable<DWType> validatable, ValidationContext ctx) {
        ObjectType connectorType = (ObjectType)validatable.getElement();
        Optional operationsProperty = DWTypeUtils.getFieldByName((ObjectType)connectorType, (String)this.propertyName);
        if (operationsProperty.isEmpty()) {
            return;
        }
        KeyValuePairType[] keyValuePairTypeArray = ((KeyValuePairType)operationsProperty.get()).getValue();
        if (!(keyValuePairTypeArray instanceof ObjectType)) {
            ctx.addError(((KeyValuePairType)operationsProperty.get()).getLocation(), "Invalid type for property '" + this.propertyName + "'. Expected: Object; Actual: " + ((KeyValuePairType)operationsProperty.get()).getValue().toString(), "connector");
            return;
        }
        ObjectType operationsObject = (ObjectType)keyValuePairTypeArray;
        for (KeyValuePairType keyValuePairType : operationsObject.getProperties()) {
            String name = DWTypeUtils.getKey((KeyValuePairType)keyValuePairType);
            if (keyValuePairType.repeated()) {
                ctx.addError(operationsObject.getLocation(), "Duplicated " + this.componentToExtract.name().replace('_', ' ').toLowerCase(Locale.ROOT) + " name '" + name + "' found.", "connector");
            }
            DWType weaveType = keyValuePairType.getValue();
            if (this.resolve) {
                weaveType = TypeUtils.resolveReferenceType((DWType)weaveType);
            }
            this.onEachComponent(ctx, weaveType, name);
            ctx.queue(ctx.validatable(weaveType).withType(this.componentToExtract).withName(name).build());
        }
    }

    protected void onEachComponent(ValidationContext ctx, DWType weaveType, String name) {
    }
}

