/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation;

import com.mulesoft.connectivity.validation.IssueSink;
import com.mulesoft.connectivity.validation.MessageCollectorIssueSink;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import com.mulesoft.connectivity.validation.ValidationEngine;
import java.util.Arrays;
import java.util.Objects;
import org.mule.weave.v2.api.tooling.annotation.DWAbstractTypeAnnotationProcessor;
import org.mule.weave.v2.api.tooling.annotation.DWAnnotationContext;
import org.mule.weave.v2.api.tooling.annotation.DWAnnotationProcessor;
import org.mule.weave.v2.api.tooling.ast.DWAstNode;
import org.mule.weave.v2.api.tooling.ast.DWAstNodeHelper;
import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.phase.DefaultAnnotationContext;
import org.mule.weave.v2.runtime.ParserConfiguration;
import org.mule.weave.v2.runtime.ParserConfigurationBuilder;
import org.mule.weave.v2.ts.TypeHelper;

public class ConnectorValidationAnnotationProcessor
extends DWAbstractTypeAnnotationProcessor {
    private final ValidationConfiguration validationConfiguration;

    public ConnectorValidationAnnotationProcessor(ValidationConfiguration validationConfiguration) {
        this.validationConfiguration = Objects.requireNonNull(validationConfiguration, "validationConfiguration can't be null");
    }

    public static ParserConfiguration getParserConfigurationForValidation(NameIdentifier connectorElement, ValidationConfiguration validationConfiguration) {
        ParserConfigurationBuilder configurationBuilder = new ParserConfigurationBuilder();
        configurationBuilder.addAnnotationProcessor(connectorElement, (DWAnnotationProcessor)new ConnectorValidationAnnotationProcessor(validationConfiguration));
        return configurationBuilder.build();
    }

    public void run(DWAstNode annotatedNode, DWAstNode annotation, DWAnnotationContext context) {
        Arrays.stream(DWAstNodeHelper.getChildrenByKind((DWAstNode)annotatedNode, (String)DWAstNodeKind.NAME_IDENTIFIER())).findFirst().flatMap(DWAstNode::getTypeOf).filter(ObjectType.class::isInstance).ifPresent(targetWeaveType -> {
            TypeHelper typeHelper = ((DefaultAnnotationContext)context).parsingContext().typeHelper();
            new ValidationEngine((ObjectType)targetWeaveType, this.getIssueSink(context), this.validationConfiguration, typeHelper).run();
        });
    }

    protected IssueSink getIssueSink(DWAnnotationContext context) {
        return new MessageCollectorIssueSink(context.getMessageCollector());
    }
}

