/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation.rules;

import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.IntersectionType;

public class IntersectionRule
extends Rule<IntersectionType> {
    public IntersectionRule() {
        super(IntersectionType.class);
    }

    @Override
    protected void validate(Validatable<IntersectionType> validatable, ValidationContext ctx) {
        for (DWType type : validatable.getElement().intersectionOf()) {
            if (validatable.getPath().map(Validatable::getElement).anyMatch(e -> e == type)) {
                String path = validatable.stringPath();
                ctx.addError(type.getLocation(), "Recursive reference to type " + String.valueOf(type) + (String)(path.isEmpty() ? "" : " at " + path), "InvalidFlowType");
                return;
            }
            ctx.queue(ctx.validatable(type).build());
        }
    }

    @Override
    public boolean appliesTo(Validatable<IntersectionType> validatable) {
        return super.appliesTo(validatable) && (validatable.hasContext(ValidatableType.INPUT) || validatable.hasContext(ValidatableType.OUTPUT));
    }
}

