/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation.rules;

import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

public class ObjectRule
extends Rule<ObjectType> {
    public ObjectRule() {
        super(ObjectType.class);
    }

    @Override
    protected void validate(Validatable<ObjectType> validatable, ValidationContext ctx) {
        ObjectType type = validatable.getElement();
        for (KeyValuePairType keyValuePair : type.getProperties()) {
            DWType value = keyValuePair.getValue();
            if (validatable.getPath().map(Validatable::getElement).anyMatch(e -> e == value)) {
                String path = validatable.stringPath();
                ctx.addError(value.getLocation(), "Recursive reference to type " + String.valueOf(value) + (String)(path.isEmpty() ? "" : " at " + path), "InvalidFlowType");
                return;
            }
            ctx.queue(ctx.validatable(value).withName(DWTypeUtils.getKey((KeyValuePairType)keyValuePair)).build());
        }
    }

    @Override
    public boolean appliesTo(Validatable<ObjectType> validatable) {
        return super.appliesTo(validatable) && (validatable.hasContext(ValidatableType.INPUT) || validatable.hasContext(ValidatableType.OUTPUT));
    }
}

