/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation.rules;

import java.util.Objects;
import org.mule.weave.v2.api.tooling.ts.DWType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Message {
    protected final DWType type;

    private Message(DWType type) {
        this.type = Objects.requireNonNull(type);
    }

    public DWType getType() {
        return this.type;
    }

    public abstract DWType getContext();

    public static Message input(DWType type) {
        return new Input(type);
    }

    public static Message output(DWType type, DWType context) {
        if (type == context) {
            throw new IllegalArgumentException("Context for the output must not be the same as the main type, it should be the input type");
        }
        return new Output(type, context);
    }

    public abstract boolean isInput();

    static final class Input
    extends Message {
        private Input(DWType type) {
            super(type);
        }

        @Override
        public DWType getContext() {
            return this.type;
        }

        @Override
        public boolean isInput() {
            return true;
        }

        public String toString() {
            return "Input{" + String.valueOf(this.type) + "}";
        }
    }

    static final class Output
    extends Message {
        private final DWType context;

        private Output(DWType type, DWType context) {
            super(type);
            this.context = Objects.requireNonNull(context);
        }

        @Override
        public DWType getContext() {
            return this.context;
        }

        @Override
        public boolean isInput() {
            return false;
        }

        public String toString() {
            return "Output{" + String.valueOf(this.type) + "}";
        }
    }
}

