/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation.rules;

import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.DWType;

public class ArrayRule
extends Rule<ArrayType> {
    public ArrayRule() {
        super(ArrayType.class);
    }

    @Override
    protected void validate(Validatable<ArrayType> validatable, ValidationContext ctx) {
        DWType value = validatable.getElement().arrayOf();
        if (validatable.getPath().map(Validatable::getElement).anyMatch(e -> e == value)) {
            String path = validatable.stringPath();
            ctx.addError(value.getLocation(), "Recursive reference to type " + String.valueOf(value) + (String)(path.isEmpty() ? "" : " at " + path), "InvalidFlowType");
            return;
        }
        if (MetadataUtils.getMetadataProvider((DWType)((DWType)validatable.getElement())).isPresent()) {
            String path = validatable.stringPath();
            ctx.addError(value.getLocation(), "Unsupported metadata provider " + (String)(path.isEmpty() ? "" : " at " + path) + ": unsupported type Array", "InvalidFlowType");
        }
        ctx.queue(ctx.validatable(validatable.getElement().arrayOf()).withName("[]").build());
    }
}

