/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation.rules;

import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Message;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.Optional;
import org.mule.weave.v2.api.tooling.location.Location;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.FunctionType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.ts.WeaveType;

public class ConnectionRule
extends Rule<DWType> {
    public ConnectionRule() {
        super(DWType.class, ValidatableType.CONNECTION);
    }

    @Override
    protected void validate(Validatable<DWType> validatable, ValidationContext ctx) {
        DWType weaveType = validatable.getElement();
        Location connectionLocation = weaveType.getLocation();
        WeaveType weaveType2 = WeaveTypeSimplifier.resolveIntersection((WeaveType)((WeaveType)weaveType));
        if (weaveType2 instanceof ObjectType) {
            ObjectType objectType = (ObjectType)weaveType2;
            Optional maybe = DWTypeUtils.getFieldByName((ObjectType)objectType, (String)"connect");
            maybe.ifPresentOrElse(ex -> this.validateConnectFunction(ctx, (KeyValuePairType)ex), () -> ctx.addError(objectType.getLocation(), "Missing connect property in connection definition", "connector"));
        } else {
            ctx.addError(connectionLocation, "Invalid type for connection '" + (String)validatable.getName().orElse(null) + "'. Expected: Connection Actual: " + String.valueOf(weaveType), "connector");
        }
    }

    private void validateConnectFunction(ValidationContext ctx, KeyValuePairType connect) {
        DWType connectType = connect.getValue();
        if (!(connectType instanceof FunctionType)) {
            ctx.addError(connect.getLocation(), "Invalid type for property 'connect'. Expected: Function; Actual: " + String.valueOf(connectType), "connector");
            return;
        }
        FunctionType functionType = (FunctionType)connectType;
        FunctionType connectFunction = functionType;
        if (connectFunction.getParameters().length != 1) {
            ctx.addError(connect.getLocation(), "Invalid type for property 'connect'. Expected an connect function but got " + String.valueOf(connectType), "connector");
            return;
        }
        DWType inputType = connectFunction.getParameters()[0].getType();
        ctx.queue(ctx.validatable(Message.input(inputType)).withType(ValidatableType.INPUT).withLocation(inputType.getLocation()).build());
    }
}

