/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation.rules;

import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;
import org.mule.weave.v2.ts.Metadata;
import org.mule.weave.v2.ts.WeaveType;

public class ReferenceRule
extends Rule<ReferenceType> {
    public ReferenceRule() {
        super(ReferenceType.class);
    }

    @Override
    protected void validate(Validatable<ReferenceType> validatable, ValidationContext ctx) {
        ReferenceType ref = validatable.getElement();
        DWType resolvedType = ref.resolveType();
        if (ref.getTypeMetadata().length > 0) {
            if (resolvedType instanceof WeaveType) {
                WeaveType objectType = (WeaveType)resolvedType;
                WeaveType newObject = objectType.cloneType();
                for (DWMetadata md : ref.getTypeMetadata()) {
                    newObject.withMetadata((Metadata)md);
                }
                ctx.queue(ctx.validatable(newObject).build());
                return;
            }
            throw new UnsupportedOperationException("Unknown DW type implementation: " + String.valueOf(resolvedType.getClass()));
        }
        ctx.queue(ctx.validatable(resolvedType).build());
    }

    @Override
    public boolean appliesTo(Validatable<ReferenceType> validatable) {
        return super.appliesTo(validatable) && (validatable.hasContext(ValidatableType.INPUT) || validatable.hasContext(ValidatableType.OUTPUT));
    }
}

