/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation;

import com.mulesoft.connectivity.validation.Issue;
import com.mulesoft.connectivity.validation.IssueSink;
import com.mulesoft.connectivity.validation.Validatable;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.impl.message.DefaultMessageBuilder;
import org.mule.weave.v2.api.tooling.location.Location;
import org.mule.weave.v2.api.tooling.message.Message;
import org.mule.weave.v2.api.tooling.message.MessageCollector;
import org.mule.weave.v2.api.tooling.message.ValidationMessage;

public class MessageCollectorIssueSink
extends IssueSink {
    private final MessageCollector messageCollector;

    public MessageCollectorIssueSink(MessageCollector messageCollector) {
        this.messageCollector = messageCollector;
    }

    @Override
    public void accept(Issue issue, @Nullable Validatable<?> validatable) {
        ValidationMessage validationMessage = MessageCollectorIssueSink.createValidationMessage(issue.getLocation(), issue.getMessage(), issue.getErrorType());
        switch (issue.getLevel()) {
            case ERROR: {
                this.messageCollector.addErrorValidationMessage(validationMessage);
                break;
            }
            case WARNING: {
                this.messageCollector.addWarningValidationMessage(validationMessage);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown issue level: " + String.valueOf((Object)issue.getLevel()));
            }
        }
    }

    private static ValidationMessage createValidationMessage(Location location, String message, String errorType) {
        Message apiMessage = new DefaultMessageBuilder().withKind(errorType).withMessage(message).build();
        return new ValidationMessage(apiMessage, location);
    }
}

