/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation.rules;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.validation.ProviderType;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.SimpleReferenceType;

public class ProviderRule
extends Rule<DWType> {
    private final ProviderType providerType;

    public ProviderRule(ProviderType providerType) {
        super(DWType.class, ProviderRule.providerTypeToValidatableType(providerType));
        this.providerType = providerType;
    }

    @Override
    protected void validate(Validatable<DWType> validatable, ValidationContext ctx) {
        SimpleReferenceType valueProviderHandle = (SimpleReferenceType)validatable.getElement();
        DWType inputType = TypeUtils.resolveReferenceType((DWType)((DWType[])valueProviderHandle.getTypeParameters().orElseThrow())[0]);
        if (!(inputType instanceof ObjectType)) {
            ctx.addError(validatable.getLocation(), "Invalid type for " + this.providerType.description() + " input type. Expected: Object; Actual: " + String.valueOf(inputType), "connector");
        }
    }

    public static ValidatableType providerTypeToValidatableType(ProviderType providerType) {
        return switch (providerType) {
            default -> throw new IncompatibleClassChangeError();
            case ProviderType.VALUE_PROVIDER -> ValidatableType.VALUE_PROVIDER;
            case ProviderType.METADATA_PROVIDER -> ValidatableType.METADATA_PROVIDER;
        };
    }

    public static ProviderType validatableTypeToProviderType(ValidatableType validatableType) {
        return switch (validatableType) {
            case ValidatableType.VALUE_PROVIDER -> ProviderType.VALUE_PROVIDER;
            case ValidatableType.METADATA_PROVIDER -> ProviderType.METADATA_PROVIDER;
            default -> throw new IllegalStateException("Not a provider: " + String.valueOf((Object)validatableType));
        };
    }
}

