/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation.rules;

import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import java.util.EnumSet;
import java.util.Set;
import org.mule.weave.v2.api.tooling.ts.DWType;

public abstract class Rule<E> {
    private final Class<E> cl;
    private final Set<ValidatableType> types;

    protected Rule(Class<E> cl, Set<ValidatableType> types) {
        this.cl = cl;
        this.types = types;
    }

    protected Rule(Class<E> cl) {
        this(cl, EnumSet.noneOf(ValidatableType.class));
    }

    protected Rule(Class<E> cl, ValidatableType type) {
        this(cl, EnumSet.of(type));
    }

    public final void callValidate(Validatable<?> validatable, ValidationContext ctx) {
        if (!this.cl.isInstance(validatable.getElement())) {
            throw new IllegalArgumentException(String.format("%s is not an instance of %s", validatable.getClass().getSimpleName(), this.cl.getSimpleName()));
        }
        this.validate(validatable, ctx);
    }

    protected abstract void validate(Validatable<E> var1, ValidationContext var2);

    public final boolean callApplyTo(Validatable<?> validatable) {
        return this.cl.isInstance(validatable.getElement()) && this.appliesTo(validatable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean appliesTo(Validatable<E> validatable) {
        if (this.types.isEmpty()) return true;
        if (!this.types.stream().anyMatch(validatable::hasType)) return false;
        return true;
    }

    public void runAfter(DWType connector, ValidationContext ctx) {
    }
}

