/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation;

import com.mulesoft.connectivity.validation.Issue;
import com.mulesoft.connectivity.validation.IssueSink;
import com.mulesoft.connectivity.validation.ProviderType;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.parser.phase.listener.ParsingNotificationManager;
import org.mule.weave.v2.ts.TypeHelper;

public class ValidationEngine {
    private static final boolean DEBUG = false;
    private final TypeHelper typeHelper;
    private final List<Class<? extends Rule<?>>> rulesClasses;
    private final ObjectType connectorType;
    private final IssueSink issueSink;
    private final Map<ProviderKey, DWType> providers = new ConcurrentHashMap<ProviderKey, DWType>();

    public ValidationEngine(ObjectType connectorType, IssueSink issueSink, ValidationConfiguration validationConfiguration, @Nullable TypeHelper typeHelper) {
        this.connectorType = connectorType;
        this.issueSink = issueSink;
        this.rulesClasses = Objects.requireNonNull(validationConfiguration, "validationConfiguration can't be null").getRules().toList();
        this.typeHelper = Objects.requireNonNullElse(typeHelper, new TypeHelper(new ParsingNotificationManager()));
    }

    public void run() {
        List<Rule> rules = this.rulesClasses.stream().map(cl -> {
            try {
                return (Rule)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }).toList();
        ArrayDeque pending = new ArrayDeque();
        pending.add(new Validatable.Builder<ObjectType>(this.connectorType).withType(ValidatableType.CONNECTOR).build());
        while (!pending.isEmpty()) {
            Validatable v = (Validatable)pending.poll();
            for (Rule r : rules) {
                if (!r.callApplyTo(v)) continue;
                r.callValidate(v, new ContextImpl(v, pending));
            }
        }
        for (Rule r : rules) {
            r.runAfter((DWType)this.connectorType, new RunAfterContextImpl());
        }
    }

    private @Nullable DWType getProvider(ProviderType type, String name) {
        return this.providers.get(new ProviderKey(name, type));
    }

    private class ContextImpl
    extends BaseContextImpl {
        private final Validatable<?> current;
        private final Queue<Validatable<?>> pending;

        ContextImpl(Validatable<?> current, Queue<Validatable<?>> pending) {
            this.current = current;
            this.pending = pending;
        }

        @Override
        public void queue(Validatable<?> validatable) {
            this.pending.add(validatable);
        }

        @Override
        public void registerProvider(ProviderType type, String name, DWType provider) {
            ValidationEngine.this.providers.put(new ProviderKey(name, type), provider);
        }

        @Override
        public <E> Validatable.Builder<E> validatable(E element) {
            return super.validatable(element).withContext(this.current.getContext()).withContext(this.current.getTypes()).withParent(this.current);
        }

        @Override
        public Optional<Validatable<?>> getCurrent() {
            return Optional.of(this.current);
        }
    }

    private class RunAfterContextImpl
    extends BaseContextImpl {
        private RunAfterContextImpl() {
        }

        @Override
        public void queue(Validatable<?> validatable) {
            throw new IllegalStateException("Can't add elements to validate at this time");
        }

        @Override
        public void registerProvider(ProviderType type, String name, DWType provider) {
            throw new IllegalStateException("Can't register a provider at this time");
        }
    }

    record ProviderKey(String name, ProviderType type) {
    }

    private abstract class BaseContextImpl
    extends ValidationContext {
        private BaseContextImpl() {
        }

        protected Optional<Validatable<?>> getCurrent() {
            return Optional.empty();
        }

        @Override
        public void report(Issue issue) {
            ValidationEngine.this.issueSink.accept(issue, this.getCurrent().orElse(null));
        }

        @Override
        public @Nullable DWType getProvider(ProviderType type, String name) {
            return ValidationEngine.this.getProvider(type, name);
        }

        @Override
        public TypeHelper getTypeHelper() {
            return ValidationEngine.this.typeHelper;
        }
    }
}

