/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation.rules;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.validation.ProviderType;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.ProviderRule;
import java.util.Arrays;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.SimpleReferenceType;

public class MetadataProviderRule
extends ProviderRule {
    public MetadataProviderRule() {
        super(ProviderType.METADATA_PROVIDER);
    }

    @Override
    protected void validate(Validatable<DWType> validatable, ValidationContext ctx) {
        super.validate(validatable, ctx);
        SimpleReferenceType mpRef = (SimpleReferenceType)validatable.getElement();
        DWType inputTypeofMetadataProvider = TypeUtils.resolveReferenceType((DWType)((DWType[])mpRef.getTypeParameters().orElseThrow())[0]);
        if (!(inputTypeofMetadataProvider instanceof ObjectType)) {
            return;
        }
        ObjectType inputTypeofMetadataProviderObject = (ObjectType)inputTypeofMetadataProvider;
        if (Arrays.stream(inputTypeofMetadataProviderObject.getProperties()).anyMatch(param -> param.getValue() instanceof ArrayType)) {
            ctx.addError(inputTypeofMetadataProviderObject.getLocation(), "Array type arguments are not allowed for dynamic metadata providers", "connector");
        }
    }
}

