/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation;

import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mule.weave.v2.api.tooling.location.Location;
import org.mule.weave.v2.api.tooling.ts.DWType;

class ValidatableTest {
    ValidatableTest() {
    }

    @Test
    void testBuilderCreation() {
        String element = "test";
        Validatable validatable = new Validatable.Builder((Object)element).withType(ValidatableType.INPUT).withName("testName").build();
        MatcherAssert.assertThat((Object)((String)validatable.getElement()), (Matcher)Matchers.is((Object)element));
        MatcherAssert.assertThat((Object)validatable.hasType(ValidatableType.INPUT), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)validatable.getName().orElse(""), (Matcher)Matchers.is((Object)"testName"));
    }

    @Test
    void testWithContext() {
        Validatable validatable = new Validatable.Builder((Object)"test").withType(ValidatableType.INPUT).withContext(ValidatableType.OPERATION).build();
        MatcherAssert.assertThat((Object)validatable.hasContext(ValidatableType.OPERATION), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void testWithParent() {
        Validatable parent = new Validatable.Builder((Object)"parent").withType(ValidatableType.OPERATION).withName("operationName").build();
        Validatable child = new Validatable.Builder((Object)"child").withType(ValidatableType.INPUT).withParent(parent).build();
        MatcherAssert.assertThat((Object)child.getParent(), (Matcher)Matchers.is((Object)parent));
        MatcherAssert.assertThat((Object)child.stringPath(), (Matcher)Matchers.is((Object)"input"));
    }

    @Test
    void testPathDescription() {
        Validatable validatable = new Validatable.Builder((Object)"test").withType(ValidatableType.INPUT).withName("testName").build();
        MatcherAssert.assertThat((Object)validatable.toString(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"testName"), (Matcher)Matchers.containsString((String)"INPUT")));
    }

    @Test
    void testHasAnyType() {
        Validatable validatable = new Validatable.Builder((Object)"test").withType(ValidatableType.INPUT).withType(ValidatableType.OUTPUT).build();
        MatcherAssert.assertThat((Object)validatable.hasAnyType(new ValidatableType[]{ValidatableType.INPUT, ValidatableType.OUTPUT}), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)validatable.hasAnyType(new ValidatableType[]{ValidatableType.OPERATION}), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void testGetTypes() {
        Validatable validatable = new Validatable.Builder((Object)"test").withType(ValidatableType.INPUT).withType(ValidatableType.OUTPUT).build();
        Set types = validatable.getTypes();
        MatcherAssert.assertThat((Object)types, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)types, (Matcher)Matchers.containsInAnyOrder((Object[])new ValidatableType[]{ValidatableType.INPUT, ValidatableType.OUTPUT}));
    }

    @Test
    void testGetContext() {
        Validatable validatable = new Validatable.Builder((Object)"test").withType(ValidatableType.INPUT).withContext(ValidatableType.OPERATION).withContext(ValidatableType.CONNECTOR).build();
        Set context = validatable.getContext();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.containsInAnyOrder((Object[])new ValidatableType[]{ValidatableType.OPERATION, ValidatableType.CONNECTOR}));
    }

    @Test
    void testGetNameReturnEmptyOptionalWhenNameIsNull() {
        Validatable validatable = new Validatable.Builder((Object)"test").withType(ValidatableType.INPUT).build();
        Assertions.assertTrue((boolean)validatable.getName().isEmpty());
    }

    @Test
    void testGetLocationWithDWType() {
        DWType dwType = (DWType)Mockito.mock(DWType.class);
        Location location = (Location)Mockito.mock(Location.class);
        Mockito.when((Object)dwType.getLocation()).thenReturn((Object)location);
        Validatable validatable = new Validatable.Builder((Object)dwType).withType(ValidatableType.INPUT).build();
        MatcherAssert.assertThat((Object)validatable.getLocation(), (Matcher)Matchers.sameInstance((Object)location));
    }

    @Test
    void testGetLocationWithExplicitLocation() {
        Location location = (Location)Mockito.mock(Location.class);
        Validatable validatable = new Validatable.Builder((Object)"test").withType(ValidatableType.INPUT).withLocation(location).build();
        MatcherAssert.assertThat((Object)validatable.getLocation(), (Matcher)Matchers.sameInstance((Object)location));
    }

    @Test
    void testGetLocationThrowsException() {
        Validatable validatable = new Validatable.Builder((Object)"test").withType(ValidatableType.INPUT).build();
        Assertions.assertThrows(IllegalStateException.class, () -> ((Validatable)validatable).getLocation());
    }

    @Test
    void testStringPathWithMultipleLevels() {
        Validatable grandparent = new Validatable.Builder((Object)"grandparent").withType(ValidatableType.OPERATION).withName("grandparentName").build();
        Validatable parent = new Validatable.Builder((Object)"parent").withType(ValidatableType.INPUT).withName("parentName").withParent(grandparent).build();
        Validatable child = new Validatable.Builder((Object)"child").withType(ValidatableType.OUTPUT).withName("childName").withParent(parent).build();
        MatcherAssert.assertThat((Object)child.stringPath(), (Matcher)Matchers.is((Object)"input.output"));
    }

    @Test
    void testPathDescriptionWithNoName() {
        Validatable validatable = new Validatable.Builder((Object)"test").withType(ValidatableType.INPUT).build();
        MatcherAssert.assertThat((Object)validatable.toString(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"String"), (Matcher)Matchers.containsString((String)"INPUT")));
    }
}

