/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.validation.rules;

import com.mulesoft.connectivity.linkweave.api.loader.ContextVariablesResolver;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Message;
import com.mulesoft.connectivity.validation.rules.Rule;
import org.mule.weave.v2.api.tooling.location.Location;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.IntersectionType;
import org.mule.weave.v2.api.tooling.ts.KeyType;
import org.mule.weave.v2.api.tooling.ts.NameType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.SimpleReferenceType;

public class MessageRule
extends Rule<Message> {
    public MessageRule() {
        super(Message.class);
    }

    @Override
    protected void validate(Validatable<Message> validatable, ValidationContext ctx) {
        Message m = validatable.getElement();
        DWType type = TypeUtils.resolveReferenceType((DWType)m.getType());
        boolean input = m.isInput();
        if (validatable.hasAnyContext(ValidatableType.OPERATION, ValidatableType.TRIGGER) && input && !(type instanceof ObjectType)) {
            ctx.addError(type.getLocation(), "Unsupported type at input: " + String.valueOf(type), "InvalidFlowType");
            return;
        }
        if (this.isPaginatedResponse(type)) {
            ctx.addWarning(validatable.getLocation(), "Skipping validation of paginated operation response", "connector");
            return;
        }
        ContextVariablesResolver.resolveContextVariables((DWType)type, (DWType)m.getContext(), (boolean)input, null, (msg, loc) -> ctx.addError((Location)loc, (String)msg, "connector"));
        ctx.queue(ctx.validatable(m.getType()).build());
    }

    private boolean isPaginatedResponse(DWType type) {
        return MessageRule.isObjectType(type) && MessageRule.isKeyPresent(type, "value") && MessageRule.isKeyPresent(type, "items") && MessageRule.isKeyPresent(type, "nextPage");
    }

    private static boolean isKeyPresent(DWType type, String key) {
        return TypeUtils.getObjectProperty((DWType)type, (String)key).flatMap(kv -> ((NameType)((KeyType)kv.getKey()).getName()).getValue()).isPresent();
    }

    private static boolean isObjectType(DWType propertyType) {
        return propertyType instanceof ObjectType || propertyType instanceof IntersectionType || propertyType instanceof SimpleReferenceType && MessageRule.isObjectType(TypeUtils.resolveReferenceType((DWType)propertyType));
    }
}

