/*
 * Decompiled with CFR 0.152.
 */
package org.connectivity.testgen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.connectivity.testgen.OperationMethod;
import org.connectivity.testgen.Operations;
import org.connectivity.testgen.ParameterName;
import org.connectivity.testgen.Parameters;
import org.connectivity.testgen.TreeNode;
import org.connectivity.testgen.metadata.OpenApiMetadataGenerator;
import org.connectivity.testgen.utils.HelperUtils;
import org.connectivity.testgen.utils.YamlToJsonConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCodeGen {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(TestCodeGen.class);
    private static String testTargetPath = "";
    private static final String TEST_PATH = "/test/dw/saas";
    private static final String UTILS_PATH = "/test/dw/utils/";
    private static final String TEST_METADATA_PATH = "/.linkweave/project-meta-test.json";
    private static final String CONNECTOR_METADATA_PATH = "/.linkweave/project-meta.json";
    private static final String TEST_VARIABLE_PREFIX = "V";
    private static String connectorName;

    private TestCodeGen() {
    }

    private static TreeNode parseTree(String currentPath, JsonNode jsonNode, Set<String> paths) {
        TreeNode node = new TreeNode();
        node.setPath(currentPath);
        node.setChildren(new ArrayList<TreeNode>());
        node.setMethods(new TreeMap<OperationMethod, Operations>(Comparator.comparingInt(TestCodeGen::methodOrder)));
        if (jsonNode.isObject()) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            objectNode.fieldNames().forEachRemaining(fieldName -> {
                JsonNode fieldNode = objectNode.get((String)fieldName);
                if ("security".equals(fieldName)) {
                    return;
                }
                if (fieldNode.isObject() && !TestCodeGen.isOperationMethod(fieldName)) {
                    if (paths.contains(currentPath + fieldName)) {
                        TreeNode childNode = TestCodeGen.parseTree(currentPath + fieldName, fieldNode, paths);
                        node.getChildren().add(childNode);
                    }
                } else if (TestCodeGen.isOperationMethod(fieldName) && fieldNode.get("operationId") != null) {
                    OperationMethod operationMethod = OperationMethod.valueOf(fieldName.toUpperCase());
                    Operations operations = TestCodeGen.handleOperationMethod(fieldName, fieldNode);
                    node.getMethods().put(operationMethod, operations);
                }
            });
        }
        return node;
    }

    private static Operations handleOperationMethod(String fieldName, JsonNode fieldNode) {
        OperationMethod.valueOf(fieldName.toUpperCase());
        Operations operations = new Operations();
        operations.setOperationId(fieldNode.get("operationId").asText());
        JsonNode parametersNode = fieldNode.get("parameters");
        if (parametersNode != null && parametersNode.isObject()) {
            Parameters parameters = new Parameters();
            if (parametersNode.has("input")) {
                parameters.setInput(parametersNode.get("input"));
            }
            if (parametersNode.has("output")) {
                parameters.setOutput(parametersNode.get("output"));
            }
            operations.setParameters(parameters);
        }
        return operations;
    }

    private static boolean isOperationMethod(String fieldName) {
        return Arrays.stream(OperationMethod.values()).map(Enum::name).anyMatch(m4 -> m4.equalsIgnoreCase(fieldName));
    }

    private static int methodOrder(OperationMethod method) {
        return switch (method) {
            default -> throw new IncompatibleClassChangeError();
            case OperationMethod.POST -> 1;
            case OperationMethod.PUT -> 2;
            case OperationMethod.PATCH -> 3;
            case OperationMethod.GET -> 4;
            case OperationMethod.DELETE -> 5;
        };
    }

    public static TreeNode parseTreeFromFile(File file, String projectMetadataPath) throws IOException {
        JsonNode rootNode = MAPPER.readTree(file);
        Set<String> paths = HelperUtils.extractAllSubtreesFromJsonFile(projectMetadataPath, MAPPER);
        return TestCodeGen.parseTree("", rootNode, paths);
    }

    private static void categorizeParameters(JsonNode parameters, Map<String, Object> queryParams, Map<String, Object> pathParams, Map<String, Object> headerParams, Map<String, Object> bodyParams) {
        if (parameters != null) {
            parameters.fields().forEachRemaining(param -> {
                String paramName = (String)param.getKey();
                JsonNode paramValue = (JsonNode)param.getValue();
                if (paramValue.isObject()) {
                    if (paramName.equals(ParameterName.query.name())) {
                        paramValue.fields().forEachRemaining(queryParam -> {
                            JsonNode schemaNode = (JsonNode)queryParam.getValue();
                            if (schemaNode != null) {
                                queryParams.put((String)queryParam.getKey(), HelperUtils.generateSampleValue(schemaNode).toString());
                            }
                        });
                    }
                    if (paramName.equals(ParameterName.path.name())) {
                        paramValue.fields().forEachRemaining(pathParam -> {
                            JsonNode schemaNode = (JsonNode)pathParam.getValue();
                            if (schemaNode != null) {
                                pathParams.put((String)pathParam.getKey(), HelperUtils.generateSampleValue(schemaNode).toString());
                            }
                        });
                    } else if (paramName.equals(ParameterName.header.name())) {
                        paramValue.fields().forEachRemaining(field -> headerParams.put((String)field.getKey(), HelperUtils.generateSampleValue((JsonNode)field.getValue()).toString()));
                    } else if (paramName.equals(ParameterName.body.name())) {
                        HashMap<String, Object> bodyFields = new HashMap<String, Object>();
                        TestCodeGen.populateBodyFields(paramValue, bodyFields);
                        bodyParams.put(paramName, bodyFields);
                    }
                }
            });
        }
    }

    private static void populateBodyFields(JsonNode paramValue, Map<String, Object> bodyFields) {
        if (paramValue != null) {
            paramValue.fields().forEachRemaining(entry -> {
                if (!((JsonNode)entry.getValue()).has("ref")) {
                    if (((JsonNode)entry.getValue()).isObject() && ((JsonNode)entry.getValue()).has("type") && ((JsonNode)entry.getValue()).get("type").asText().equals("object")) {
                        HashMap<String, Object> nestedFields = new HashMap<String, Object>();
                        TestCodeGen.populateBodyFields(((JsonNode)entry.getValue()).get("properties"), nestedFields);
                        bodyFields.put((String)entry.getKey(), nestedFields);
                    } else if (((JsonNode)entry.getValue()).isObject() && ((JsonNode)entry.getValue()).has("type") && ((JsonNode)entry.getValue()).get("type").asText().equals("array")) {
                        ArrayList<Object> arrayItems = new ArrayList<Object>();
                        JsonNode itemsNode = ((JsonNode)entry.getValue()).get("items");
                        if (itemsNode.get("type") != null && itemsNode.get("type").asText().equals("object")) {
                            HashMap<String, Object> nestedFields = new HashMap<String, Object>();
                            TestCodeGen.populateBodyFields(itemsNode.get("properties"), nestedFields);
                            arrayItems.add(nestedFields);
                        } else {
                            arrayItems.add(HelperUtils.generateSampleValue(itemsNode));
                        }
                        bodyFields.put((String)entry.getKey(), arrayItems);
                    } else {
                        bodyFields.put((String)entry.getKey(), HelperUtils.generateSampleValue((JsonNode)entry.getValue()));
                    }
                }
            });
        }
    }

    private static String generateDirectoryPath(String path, String parentPath) {
        String sanitizedPath = HelperUtils.sanitizePath(path);
        return parentPath + TEST_PATH + sanitizedPath.replace("_", "/");
    }

    private static void createDirectory(String directoryPath) throws IOException {
        Files.createDirectories(Paths.get(directoryPath, new String[0]), new FileAttribute[0]);
    }

    private static String generateFilename(String directoryPath, String varName) {
        return directoryPath + "/IT_" + varName + "_Test.dwl";
    }

    public static void generateDataWeaveTest(Map<String, TreeNode> pathNodeMap) throws IOException {
        StringBuilder requests = new StringBuilder();
        StringBuilder tests = new StringBuilder();
        String filename = "";
        HashMap<String, Map<String, String>> outputBindings = new HashMap<String, Map<String, String>>();
        requests.append("%dw 2.5\nimport * from dw::test::Asserts\nimport * from dw::test::Tests\nimport * from dw::Runtime\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::Metadata\n\nimport * from utils::ConnectionOperations\nimport * from utils::RandomHelper\n\n\n");
        for (Map.Entry<String, TreeNode> entry : pathNodeMap.entrySet()) {
            TreeNode treeNode = entry.getValue();
            for (OperationMethod operationMethod : treeNode.getMethods().keySet()) {
                requests.append(String.format("import * from com::mulesoft::connectivity::%s::operations::%s", connectorName, HelperUtils.parsePathForOperationImports(treeNode.getPath(), operationMethod.name()))).append("\n");
            }
        }
        Comparator methodComparator = (o1, o2) -> {
            List<OperationMethod> order = Arrays.asList(OperationMethod.POST, OperationMethod.PUT, OperationMethod.PATCH, OperationMethod.GET, OperationMethod.DELETE);
            return Integer.compare(order.indexOf(o1), order.indexOf(o2));
        };
        for (Map.Entry<String, TreeNode> entry : pathNodeMap.entrySet()) {
            Object varName;
            TreeNode node = entry.getValue();
            String indent = "    ";
            requests.append("// ").append(node.getPath()).append("\n");
            if (node.getMethods() != null && !node.getMethods().isEmpty()) {
                TreeMap<OperationMethod, Operations> sortedMethods = new TreeMap<OperationMethod, Operations>(methodComparator);
                sortedMethods.putAll(node.getMethods());
                for (Map.Entry methodEntry : sortedMethods.entrySet()) {
                    String method = ((OperationMethod)((Object)methodEntry.getKey())).name().toLowerCase();
                    varName = HelperUtils.sanitizePath(node.getPath()) + "_" + method;
                    String directoryPath = TestCodeGen.generateDirectoryPath(node.getPath(), testTargetPath);
                    TestCodeGen.createDirectory(directoryPath);
                    filename = TestCodeGen.generateFilename(directoryPath, HelperUtils.sanitizePath(entry.getKey()).substring(1));
                    varName = TEST_VARIABLE_PREFIX.concat((String)varName);
                    requests.append("var ").append((String)varName).append("_request : ").append(HelperUtils.parsePathForOperationImports(node.getPath(), method)).append("_Type").append(".request = {\n");
                    HashMap<String, Object> queryParams = new HashMap<String, Object>();
                    HashMap<String, Object> pathParams = new HashMap<String, Object>();
                    HashMap<String, Object> headerParams = new HashMap<String, Object>();
                    HashMap<String, Object> bodyParams = new HashMap<String, Object>();
                    if (((Operations)methodEntry.getValue()).getParameters() != null) {
                        JsonNode input = ((Operations)methodEntry.getValue()).getParameters().getInput();
                        JsonNode output = ((Operations)methodEntry.getValue()).getParameters().getOutput();
                        TestCodeGen.categorizeParameters(input, queryParams, pathParams, headerParams, bodyParams);
                        if ("post".equals(method) && output != null) {
                            HelperUtils.extractAndStoreIds(output, outputBindings, (String)varName);
                        }
                    }
                    if (!pathParams.isEmpty()) {
                        requests.append(indent).append("uri: ").append(HelperUtils.formatParameters(pathParams, indent, outputBindings)).append(",\n");
                    }
                    requests.append(indent).append("query: ").append(HelperUtils.formatParameters(queryParams, indent, outputBindings)).append(",\n");
                    requests.append(indent).append("headers: ").append(HelperUtils.formatParameters(headerParams, indent, outputBindings)).append(",\n");
                    if (!bodyParams.isEmpty() && !"get".equalsIgnoreCase(method)) {
                        requests.append(indent).append(HelperUtils.formatBodyParameters(bodyParams, 1)).append(",\n");
                    }
                    requests.append(indent).append("cookie: {}\n");
                    requests.append(indent).append("}\n\n");
                    requests.append("var ").append((String)varName).append("_response = ").append(HelperUtils.parsePathForOperationImports(node.getPath(), method)).append(".executor(").append((String)varName).append("_request, connection) \n");
                }
            }
            if (node.getMethods() == null || node.getMethods().isEmpty()) continue;
            for (Map.Entry<OperationMethod, Operations> methodEntry : node.getMethods().entrySet()) {
                String method = methodEntry.getKey().name().toLowerCase();
                String status = "post".equals(method) ? "201" : "200";
                varName = HelperUtils.sanitizePath(node.getPath()) + "_" + method;
                tests.append("    \"").append(node.getPath()).append(" - ").append(method.toUpperCase()).append(" Successful Execution\" in do {\n");
                tests.append("        ").append(TEST_VARIABLE_PREFIX.concat((String)varName)).append("_response.value.status must equalTo(").append(status).append(")\n");
                tests.append("    },\n");
            }
        }
        if (!filename.isBlank()) {
            try (FileWriter fileWriter = new FileWriter(filename);){
                Iterator<String> iterator = pathNodeMap.keySet().iterator();
                String lastPath = "";
                while (iterator.hasNext()) {
                    lastPath = iterator.next();
                }
                fileWriter.write(requests.append("--- \n").append("\"").append(HelperUtils.sanitizePath(lastPath).substring(1)).append(" tests\" describedBy [\n").append((CharSequence)tests).append("]\n\n").toString());
            }
        }
    }

    public static void extractResource(String resourcePath, String outputPath) throws IOException {
        try (InputStream resourceStream = TestCodeGen.class.getClassLoader().getResourceAsStream(resourcePath);){
            if (resourceStream == null) {
                throw new FileNotFoundException("Resource not found: " + resourcePath);
            }
            Path path = Paths.get(outputPath, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.copy(resourceStream, path, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void main(String[] args) throws Exception {
        String apiSpecPath;
        if (args.length != 3) {
            LOG.error("One or more arguments missing");
            LOG.error("Usage: java -jar <project base path> <api spec path> <target folder for tests>");
            System.exit(1);
        }
        String projectPath = args[0];
        testTargetPath = args[2];
        String jsonApiSpecPath = apiSpecPath = args[1];
        if (apiSpecPath.endsWith("yaml") || apiSpecPath.endsWith("yml")) {
            YamlToJsonConverter toJsonConverter = new YamlToJsonConverter();
            jsonApiSpecPath = toJsonConverter.convertYamlToJson(apiSpecPath);
        }
        OpenApiMetadataGenerator.generateTestMetadata(jsonApiSpecPath, projectPath + TEST_METADATA_PATH);
        connectorName = HelperUtils.extractConnectorNameFromJsonFile(projectPath + CONNECTOR_METADATA_PATH, MAPPER);
        TestCodeGen.extractResource("connection_template_basic.dwl", testTargetPath + "/test/dw/utils/ConnectionOperations.dwl");
        TestCodeGen.extractResource("RandomHelper.dwl", testTargetPath + "/test/dw/utils/RandomHelper.dwl");
        File file = new File(projectPath + TEST_METADATA_PATH);
        TreeNode root = TestCodeGen.parseTreeFromFile(file, projectPath + CONNECTOR_METADATA_PATH);
        List<Map<String, TreeNode>> pathNodeMaps = root.collectPathNodeMaps(root, new LinkedHashMap<String, TreeNode>());
        for (Map<String, TreeNode> pathNodeMap : pathNodeMaps) {
            TestCodeGen.generateDataWeaveTest(pathNodeMap);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(root.toString());
        }
    }
}

