/*
 * Copyright (c) 2025, Salesforce, Inc.,
 * All rights reserved.
 * For full license text, see the LICENSE.txt file
 */
%dw 2.5

import * from dw::Runtime

import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::Metadata


//for templating purpose,
//currently there is no way to identify how the oauth2 token is generated
// so the template assumes the token will be provided to it


var SERVICE_BASE_URL = "@@service_base_url@@"
var SERVICE_TOKEN = "@@token@@"


@ConnectionElement()
var connection = defineBearerHttpConnectionProvider<AuthConnection>(
    (parameter) -> { token: SERVICE_TOKEN },
    (parameter) -> {
        baseUri: SERVICE_BASE_URL
    }
)