/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeFeature;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class LocalDateTimeDeserializer
extends JSR310DateTimeDeserializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;
    private static final boolean DEFAULT_USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING = JavaTimeFeature.USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING.enabledByDefault();
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    public static final LocalDateTimeDeserializer INSTANCE = new LocalDateTimeDeserializer();
    protected final Boolean _readTimestampsAsNanosOverride;
    protected final boolean _useTimeZoneForLenientDateParsing;

    protected LocalDateTimeDeserializer() {
        this(DEFAULT_FORMATTER);
    }

    public LocalDateTimeDeserializer(DateTimeFormatter formatter) {
        super(LocalDateTime.class, formatter);
        this._readTimestampsAsNanosOverride = null;
        this._useTimeZoneForLenientDateParsing = DEFAULT_USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING;
    }

    protected LocalDateTimeDeserializer(LocalDateTimeDeserializer base, Boolean leniency) {
        super(base, leniency);
        this._readTimestampsAsNanosOverride = base._readTimestampsAsNanosOverride;
        this._useTimeZoneForLenientDateParsing = base._useTimeZoneForLenientDateParsing;
    }

    protected LocalDateTimeDeserializer(LocalDateTimeDeserializer base, Boolean leniency, DateTimeFormatter formatter, JsonFormat.Shape shape, Boolean readTimestampsAsNanosOverride) {
        super(base, leniency, formatter, shape);
        this._readTimestampsAsNanosOverride = readTimestampsAsNanosOverride;
        this._useTimeZoneForLenientDateParsing = base._useTimeZoneForLenientDateParsing;
    }

    protected LocalDateTimeDeserializer(LocalDateTimeDeserializer base, JacksonFeatureSet<JavaTimeFeature> features) {
        super(LocalDateTime.class, base._formatter);
        this._readTimestampsAsNanosOverride = base._readTimestampsAsNanosOverride;
        this._useTimeZoneForLenientDateParsing = features.isEnabled(JavaTimeFeature.USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING);
    }

    protected LocalDateTimeDeserializer withDateFormat(DateTimeFormatter dtf) {
        return new LocalDateTimeDeserializer(this, this._isLenient, dtf, this._shape, this._readTimestampsAsNanosOverride);
    }

    @Override
    protected LocalDateTimeDeserializer withLeniency(Boolean leniency) {
        return new LocalDateTimeDeserializer(this, leniency);
    }

    @Override
    protected JSR310DateTimeDeserializerBase<?> _withFormatOverrides(DeserializationContext ctxt, BeanProperty property, JsonFormat.Value formatOverrides) {
        LocalDateTimeDeserializer deser = (LocalDateTimeDeserializer)super._withFormatOverrides(ctxt, property, formatOverrides);
        Boolean readTimestampsAsNanosOverride = formatOverrides.getFeature(JsonFormat.Feature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
        if (!Objects.equals(readTimestampsAsNanosOverride, deser._readTimestampsAsNanosOverride)) {
            return new LocalDateTimeDeserializer(deser, deser._isLenient, deser._formatter, deser._shape, readTimestampsAsNanosOverride);
        }
        return deser;
    }

    public LocalDateTimeDeserializer withFeatures(JacksonFeatureSet<JavaTimeFeature> features) {
        if (this._useTimeZoneForLenientDateParsing == features.isEnabled(JavaTimeFeature.USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING)) {
            return this;
        }
        return new LocalDateTimeDeserializer(this, features);
    }

    @Override
    public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasTokenId(6)) {
            return this._fromString(p, ctxt, p.getText());
        }
        if (p.isExpectedStartObjectToken()) {
            String str = ctxt.extractScalarFromObject(p, this, this.handledType());
            if (str != null) {
                return this._fromString(p, ctxt, str);
            }
            return (LocalDateTime)this._handleUnexpectedToken(ctxt, p, "Expected array or string", new Object[0]);
        }
        if (p.isExpectedStartArrayToken()) {
            JsonToken t2 = p.nextToken();
            if (t2 == JsonToken.END_ARRAY) {
                return null;
            }
            if ((t2 == JsonToken.VALUE_STRING || t2 == JsonToken.VALUE_EMBEDDED_OBJECT) && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                LocalDateTime parsed = this.deserialize(p, ctxt);
                if (p.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(p, ctxt);
                }
                return parsed;
            }
            if (t2 == JsonToken.VALUE_NUMBER_INT) {
                LocalDateTime result;
                int year = p.getIntValue();
                int month = p.nextIntValue(-1);
                int day = p.nextIntValue(-1);
                int hour = p.nextIntValue(-1);
                int minute = p.nextIntValue(-1);
                t2 = p.nextToken();
                if (t2 == JsonToken.END_ARRAY) {
                    result = LocalDateTime.of(year, month, day, hour, minute);
                } else {
                    int second = p.getIntValue();
                    t2 = p.nextToken();
                    if (t2 == JsonToken.END_ARRAY) {
                        result = LocalDateTime.of(year, month, day, hour, minute, second);
                    } else {
                        int partialSecond = p.getIntValue();
                        if (partialSecond < 1000 && !this.shouldReadTimestampsAsNanoseconds(ctxt)) {
                            partialSecond *= 1000000;
                        }
                        if (p.nextToken() != JsonToken.END_ARRAY) {
                            throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                        }
                        result = LocalDateTime.of(year, month, day, hour, minute, second, partialSecond);
                    }
                }
                return result;
            }
            ctxt.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", new Object[]{t2});
        }
        if (p.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (LocalDateTime)p.getEmbeddedObject();
        }
        if (p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            this._throwNoNumericTimestampNeedTimeZone(p, ctxt);
        }
        return (LocalDateTime)this._handleUnexpectedToken(ctxt, p, "Expected array or string", new Object[0]);
    }

    protected boolean shouldReadTimestampsAsNanoseconds(DeserializationContext context) {
        return this._readTimestampsAsNanosOverride != null ? this._readTimestampsAsNanosOverride.booleanValue() : context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
    }

    protected LocalDateTime _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        String string = string0.trim();
        if (string.length() == 0) {
            return (LocalDateTime)this._fromEmptyString(p, ctxt, string);
        }
        try {
            if (this._formatter == DEFAULT_FORMATTER && string.length() > 10 && string.charAt(10) == 'T' && string.endsWith("Z")) {
                if (this.isLenient()) {
                    if (this._useTimeZoneForLenientDateParsing) {
                        return Instant.parse(string).atZone(ctxt.getTimeZone().toZoneId()).toLocalDateTime();
                    }
                    return LocalDateTime.parse(string.substring(0, string.length() - 1), this._formatter);
                }
                JavaType t2 = this.getValueType(ctxt);
                return (LocalDateTime)ctxt.handleWeirdStringValue(t2.getRawClass(), string, "Should not contain offset when 'strict' mode set for property or type (enable 'lenient' handling to allow)", new Object[0]);
            }
            return LocalDateTime.parse(string, this._formatter);
        }
        catch (DateTimeException e) {
            return (LocalDateTime)this._handleDateTimeException(ctxt, e, string);
        }
    }
}

