/*
 * Decompiled with CFR 0.152.
 */
package org.connectivity.testgen.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.connectivity.testgen.metadata.OpenApiFlattener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiMetadataGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiMetadataGenerator.class);
    private static final String PROPERTY_APPLICATION_JSON = "application/json";

    private OpenApiMetadataGenerator() {
    }

    public static void generateTestMetadata(String openApiFilePath, String targetTestMetadataFile) throws Exception {
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setResolve(true);
        parseOptions.setResolveFully(true);
        OpenAPIV3Parser openAPIV3Parser = new OpenAPIV3Parser();
        OpenAPI openAPI = openAPIV3Parser.read(openApiFilePath, null, parseOptions);
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        for (Map.Entry entry : openAPI.getPaths().entrySet()) {
            String path = (String)entry.getKey();
            PathItem pathItem = (PathItem)entry.getValue();
            String[] segments = path.split("/");
            ObjectNode currentNode = rootNode;
            for (String segment : segments) {
                if (segment.isEmpty()) continue;
                if (!currentNode.has(OpenApiMetadataGenerator.sanitiseSegment(segment))) {
                    currentNode.set(OpenApiMetadataGenerator.sanitiseSegment(segment), mapper.createObjectNode());
                }
                currentNode = (ObjectNode)currentNode.get(OpenApiMetadataGenerator.sanitiseSegment(segment));
            }
            ObjectNode finalCurrentNode = currentNode;
            pathItem.readOperationsMap().forEach((method, operation) -> {
                ObjectNode methodNode = mapper.createObjectNode();
                methodNode.put("operationId", operation.getOperationId());
                ObjectNode inputNode = mapper.createObjectNode();
                ObjectNode outputNode = mapper.createObjectNode();
                ObjectNode nestedInnerNode = mapper.createObjectNode();
                ObjectNode queryNode = mapper.createObjectNode();
                ObjectNode pathParamNode = mapper.createObjectNode();
                ObjectNode headerNode = mapper.createObjectNode();
                ObjectNode bodyNode = mapper.createObjectNode();
                if (operation.getParameters() != null) {
                    block10: for (Parameter parameter : operation.getParameters()) {
                        String in = parameter.getIn();
                        String name2 = parameter.getName();
                        Schema<?> schema2 = OpenApiFlattener.resolveSchema(parameter.getSchema(), openAPI);
                        ObjectNode paramNode = OpenApiFlattener.flattenSchema(schema2, mapper, openAPI);
                        paramNode.put("name", name2);
                        switch (in) {
                            case "query": {
                                queryNode.set(name2, paramNode);
                                continue block10;
                            }
                            case "path": {
                                pathParamNode.set(name2, paramNode);
                                continue block10;
                            }
                            case "header": {
                                headerNode.set(name2, paramNode);
                                continue block10;
                            }
                        }
                        throw new IllegalStateException("Unexpected value: " + in);
                    }
                }
                if (operation.getRequestBody() != null && operation.getRequestBody().getContent() != null && operation.getRequestBody().getContent().get(PROPERTY_APPLICATION_JSON) != null && ((MediaType)operation.getRequestBody().getContent().get(PROPERTY_APPLICATION_JSON)).getSchema() != null && ((MediaType)operation.getRequestBody().getContent().get(PROPERTY_APPLICATION_JSON)).getSchema().getProperties() != null) {
                    ((MediaType)operation.getRequestBody().getContent().get(PROPERTY_APPLICATION_JSON)).getSchema().getProperties().forEach((name, schema) -> {
                        if (schema != null) {
                            ObjectNode bodyParamNode = OpenApiFlattener.flattenSchema(OpenApiFlattener.resolveSchema((Schema)schema, openAPI), mapper, openAPI);
                            bodyParamNode.put("name", name.toString());
                            bodyNode.set(name.toString(), bodyParamNode);
                        }
                    });
                }
                inputNode.set("query", queryNode);
                inputNode.set("path", pathParamNode);
                inputNode.set("header", headerNode);
                inputNode.set("body", bodyNode);
                nestedInnerNode.set("input", inputNode);
                nestedInnerNode.set("output", outputNode);
                methodNode.set("parameters", nestedInnerNode);
                finalCurrentNode.set(method.toString(), methodNode);
            });
        }
        Path targetTestMetadataFilePath = Paths.get(targetTestMetadataFile, new String[0]);
        if (Files.notExists(targetTestMetadataFilePath.getParent(), new LinkOption[0])) {
            Files.createDirectories(targetTestMetadataFilePath.getParent(), new FileAttribute[0]);
        }
        if (Files.notExists(targetTestMetadataFilePath, new LinkOption[0])) {
            Files.createFile(targetTestMetadataFilePath, new FileAttribute[0]);
        }
        File outputFile = new File(targetTestMetadataFile);
        try {
            mapper.registerModule(new JavaTimeModule());
            mapper.writerWithDefaultPrettyPrinter().writeValue(outputFile, (Object)rootNode);
            LOG.info("Flattened schema written to: {}", (Object)outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to extract connector name from the project-meta.json");
        }
    }

    private static String sanitiseSegment(String segment) {
        return "/" + segment;
    }
}

