/*
 * Decompiled with CFR 0.152.
 */
package org.connectivity.testgen.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class OpenApiFlattener {
    private static final int MAX_DEPTH = 50;
    private static final String PROPERTY_DEFAULT = "default";
    private static final String PROPERTY_STRING = "string";
    private static final Random RANDOM = new Random();

    private OpenApiFlattener() {
    }

    public static Schema<?> resolveSchema(Schema<?> schema, OpenAPI openAPI) {
        if (schema.get$ref() != null) {
            String ref = schema.get$ref();
            String[] refParts = ref.split("/");
            if (refParts.length < 3) {
                throw new IllegalArgumentException("Invalid reference: " + ref);
            }
            String componentType = refParts[2];
            String refName = refParts[refParts.length - 1];
            Schema referencedSchema = null;
            if ("schemas".equals(componentType)) {
                referencedSchema = (Schema)openAPI.getComponents().getSchemas().get(refName);
            } else if ("parameters".equals(componentType)) {
                referencedSchema = ((Parameter)openAPI.getComponents().getParameters().get(refParts[refParts.length - 2])).getSchema();
            }
            if (referencedSchema != null) {
                return OpenApiFlattener.resolveSchema(referencedSchema, openAPI);
            }
            Schema dummySchema = new Schema();
            dummySchema.setType(PROPERTY_STRING);
            dummySchema.setDescription("Dummy schema for unresolved reference: " + ref);
            return dummySchema;
        }
        return schema;
    }

    public static ObjectNode flattenSchema(Schema<?> schema, ObjectMapper mapper, OpenAPI openAPI) {
        return OpenApiFlattener.flattenSchema(schema, mapper, openAPI, new HashMap(), 0);
    }

    private static ObjectNode flattenSchema(Schema<?> schema, ObjectMapper mapper, OpenAPI openAPI, Map<Schema<?>, ObjectNode> processedSchemas, int depth) {
        if (depth > 50) {
            ObjectNode node = mapper.createObjectNode();
            node.put("type", "recursion limit reached");
            return node;
        }
        if (processedSchemas.containsKey(schema = OpenApiFlattener.resolveSchema(schema, openAPI))) {
            ObjectNode refNode = mapper.createObjectNode();
            refNode.put("type", schema.get$ref() != null ? schema.get$ref() : PROPERTY_STRING);
            return refNode;
        }
        ObjectNode node = mapper.createObjectNode();
        processedSchemas.put(schema, node);
        if ("object".equals(schema.getType())) {
            ObjectNode innerNode = mapper.createObjectNode();
            if (schema.getProperties() != null) {
                for (Map.Entry entry : schema.getProperties().entrySet()) {
                    Schema<?> propertySchema = OpenApiFlattener.resolveSchema((Schema)entry.getValue(), openAPI);
                    node.put("type", "object");
                    innerNode.set((String)entry.getKey(), (JsonNode)OpenApiFlattener.flattenSchema(propertySchema, mapper, openAPI, processedSchemas, depth + 1));
                    node.putPOJO("properties", (Object)innerNode);
                    OpenApiFlattener.addExampleAndDefault(schema, node);
                }
            }
        } else if ("array".equals(schema.getType())) {
            ArraySchema arraySchema = (ArraySchema)schema;
            Schema<?> itemSchema = OpenApiFlattener.resolveSchema(arraySchema.getItems(), openAPI);
            node.put("type", "array");
            node.set("items", (JsonNode)OpenApiFlattener.flattenSchema(itemSchema, mapper, openAPI, processedSchemas, depth + 1));
            OpenApiFlattener.addExampleAndDefault(itemSchema, node);
        } else {
            if (schema.getType() == null) {
                node.put("type", PROPERTY_STRING);
            } else {
                node.put("type", schema.getType());
            }
            OpenApiFlattener.addExampleAndDefault(schema, node);
        }
        return node;
    }

    private static void addExampleAndDefault(Schema<?> schema, ObjectNode node) {
        List enumValues;
        if (schema.getEnum() != null && !(enumValues = schema.getEnum()).isEmpty()) {
            Object randomEnumValue = enumValues.get(RANDOM.nextInt(enumValues.size()));
            node.putPOJO(PROPERTY_DEFAULT, randomEnumValue);
        }
        if (schema.getExample() != null) {
            node.putPOJO("example", schema.getExample());
        }
        if (schema.getDefault() != null) {
            node.putPOJO(PROPERTY_DEFAULT, schema.getDefault());
        } else if ("boolean".equals(schema.getType())) {
            node.putPOJO(PROPERTY_DEFAULT, (Object)false);
        }
    }
}

