/*
 * Decompiled with CFR 0.152.
 */
package org.connectivity.testgen.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.connectivity.testgen.CustomLinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelperUtils {
    private static final String OPERATION_PREFIX = "O_";
    private static final Logger LOG = LoggerFactory.getLogger(HelperUtils.class);
    private static final Set<String> KEYWORDS = Set.of("and", "as", "async", "case", "default", "do", "else", "enum", "false", "for", "fun", "if", "import", "input", "is", "ns", "null", "or", "output", "private", "throw", "true", "type", "unless", "using", "var", "yield");

    private HelperUtils() {
    }

    public static String parsePathForOperationImports(String path, String method) {
        return OPERATION_PREFIX.concat(HelperUtils.replaceSpecialCharacters(path.substring(1).concat("_").concat(method.toLowerCase())));
    }

    public static String replaceSpecialCharacters(String input) {
        return input.replaceAll("[^a-zA-Z0-9 ]", "_");
    }

    public static boolean containsSpecialCharacters(String s) {
        return s.codePoints().anyMatch(ch -> ch >= 128 || !Character.isLetterOrDigit(ch));
    }

    public static boolean isReservedKeyword(String s) {
        return KEYWORDS.contains(s.toLowerCase());
    }

    public static List<String> extractPairs(String url) {
        ArrayList<String> pairs = new ArrayList<String>();
        String regex = "/(\\w+)/\\{(\\w+)}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(url);
        while (matcher.find()) {
            String segment = matcher.group(1);
            String variable = matcher.group(2);
            pairs.add(segment);
            pairs.add(variable);
        }
        return pairs;
    }

    public static void extractAndStoreIds(JsonNode node, Map<String, Map<String, String>> outputBindings, String varName) {
        block4: {
            block3: {
                Map currentBindings = outputBindings.computeIfAbsent(varName, k -> new HashMap());
                if (!node.isObject()) break block3;
                Iterator fields = node.fields();
                while (fields.hasNext()) {
                    Map.Entry field = (Map.Entry)fields.next();
                    if (((String)field.getKey()).toLowerCase().endsWith("id")) {
                        currentBindings.put((String)field.getKey(), varName + "Response.value.body." + (String)field.getKey());
                        continue;
                    }
                    HelperUtils.extractAndStoreIds((JsonNode)field.getValue(), outputBindings, varName);
                }
                break block4;
            }
            if (!node.isArray()) break block4;
            for (JsonNode item : node) {
                HelperUtils.extractAndStoreIds(item, outputBindings, varName);
            }
        }
    }

    public static String formatBodyParameters(Map<String, Object> bodyParams, int indentLevel) {
        StringBuilder sb = new StringBuilder("\n");
        bodyParams.forEach((key, value) -> sb.append(HelperUtils.indent(indentLevel)).append((String)key).append(": ").append(HelperUtils.formatBodyValue(value, indentLevel)));
        sb.append(HelperUtils.indent(indentLevel));
        return sb.toString();
    }

    static String formatBodyValue(Object value, int indentLevel) {
        if (value instanceof Map) {
            Map map = (Map)value;
            StringBuilder sb = new StringBuilder("{\n");
            map.forEach((k, v) -> sb.append(HelperUtils.indent(indentLevel + 1)).append(HelperUtils.containsSpecialCharacters((String)k) || HelperUtils.isReservedKeyword((String)k) ? HelperUtils.stringify((String)k) : k).append(": ").append(HelperUtils.formatBodyValue(v, indentLevel + 1)).append(",\n"));
            sb.append(HelperUtils.indent(indentLevel)).append("}");
            return sb.toString();
        }
        if (value instanceof List) {
            List list = (List)value;
            StringJoiner sb = new StringJoiner(", ", "[", "]");
            for (Object item : list) {
                sb.add(HelperUtils.formatBodyValue(item, indentLevel));
            }
            return sb.toString();
        }
        return value.toString();
    }

    private static String indent(int level) {
        return "    ".repeat(level);
    }

    public static String formatParameters(Map<String, Object> params, String indent, Map<String, Map<String, String>> outputBindings) {
        StringBuilder formattedParams = new StringBuilder();
        formattedParams.append("{\n");
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            if (HelperUtils.containsSpecialCharacters(key) || HelperUtils.isReservedKeyword(key)) {
                key = HelperUtils.stringify(key);
            }
            StringBuilder value = new StringBuilder(entry.getValue().toString());
            for (Map.Entry<String, Map<String, String>> outputBinding : outputBindings.entrySet()) {
                if (!outputBinding.getValue().containsKey(key)) continue;
                value = new StringBuilder(outputBinding.getValue().get(key));
            }
            formattedParams.append(indent).append("    ").append(key).append(": ").append((CharSequence)value).append(",\n");
        }
        formattedParams.append(indent).append("}");
        return formattedParams.toString();
    }

    public static String stringify(String s) {
        return "\"" + s + "\"";
    }

    public static String sanitizePath(String path) {
        return HelperUtils.replaceSpecialCharacters(path);
    }

    public static Object generateSampleValue(JsonNode schemaNode) {
        if (schemaNode == null) {
            return "sampleString";
        }
        JsonNode value = schemaNode.get("default");
        if (value != null) {
            return value;
        }
        value = schemaNode.get("enum");
        if (value != null) {
            return HelperUtils.stringify(value.get(0).asText());
        }
        JsonNode type = schemaNode.get("type");
        return switch (type != null ? type.asText() : "string") {
            case "string" -> "randomString(10)";
            case "integer", "number" -> "randomIntInRange(1, 100)";
            case "boolean" -> "randomBoolean()";
            case "array" -> {
                if (schemaNode.has("items")) {
                    yield List.of(HelperUtils.generateSampleValue(schemaNode.get("items")));
                }
                yield List.of();
            }
            case "object" -> {
                CustomLinkedHashMap obj = new CustomLinkedHashMap();
                schemaNode.fields().forEachRemaining(entry -> {
                    if (!((String)entry.getKey()).equalsIgnoreCase("type")) {
                        obj.put((String)entry.getKey(), HelperUtils.generateSampleValue((JsonNode)entry.getValue()));
                    }
                });
                yield obj.toString();
            }
            default -> "sampleString";
        };
    }

    public static String extractConnectorNameFromJsonFile(String filePath, ObjectMapper objectMapper) throws IOException {
        JsonNode rootNode = objectMapper.readTree(new File(filePath));
        return rootNode.get("connectorName").asText();
    }

    public static Set<String> extractAllSubtreesFromJsonFile(String filePath, ObjectMapper objectMapper) {
        HashSet<String> subtrees = new HashSet<String>();
        try {
            JsonNode rootNode = objectMapper.readTree(new File(filePath));
            JsonNode endpointsNode = rootNode.get("endpoints");
            if (endpointsNode.isArray()) {
                for (JsonNode endpointNode : endpointsNode) {
                    String path = endpointNode.get("path").asText();
                    subtrees.addAll(HelperUtils.extractSubtrees(path));
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error reading project metadata file");
        }
        return subtrees;
    }

    private static Set<String> extractSubtrees(String path) {
        HashSet<String> subtrees = new HashSet<String>();
        String[] parts = path.split("/");
        StringBuilder currentPath = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            currentPath.append("/").append(part);
            subtrees.add(currentPath.toString());
        }
        return subtrees;
    }
}

