/*
 * Copyright (c) 2025, Salesforce, Inc.,
 * All rights reserved.
 * For full license text, see the LICENSE.txt file
 */
%dw 2.5

var words = ["Lorem", "ipsum", "dolor", "sit", "amet", "consectetur", "adipiscing", "elit", "sed", "quis", "risus", "ullamcorper", "fermentum", "dolor", "nec", "vestibulum", "purus", "nulla", "facilisi", "integer", "bibendum", "eleifend", "diam", "nec", "tristique", "tortor", "tempor", "a", "duis", "aliquam", "ultricies", "justo", "vel", "fringilla", "mi", "vehicula", "nec", "cras", "auctor", "efficitur", "nulla", "non", "cursus", "mi", "vestibulum", "id", "phasellus", "nec", "ipsum", "eu", "felis", "aliquet", "sodales", "nec", "nec", "ex", "quisque", "id", "eros", "vel", "velit", "iaculis", "rhoncus", "nulla", "ac", "ante", "aliquam", "ultrices", "arcu", "sed", "faucibus", "lacus", "sed", "rutrum", "feugiat", "tellus", "ac", "tincidunt", "lacus", "aliquam", "in", "mauris", "tempus", "sollicitudin", "enim", "eget", "ullamcorper", "urna", "proin", "accumsan", "sollicitudin", "justo", "vel", "fringilla", "eros", "tincidunt", "in", "nam", "interdum", "pharetra", "ultricies", "nam", "a", "varius", "justo", "quisque", "auctor", "varius", "est", "at", "consequat", "pellentesque", "sodales", "ex", "id", "velit", "sollicitudin", "suscipit", "nunc", "congue", "justo", "eu", "tellus", "pharetra", "tristique"]

fun randomText() =
  trim("" ++ (1 to (floor(random() * 150) + 50) map ((n) -> words[random() * sizeOf(words) as Number] ) joinBy " "))

var alphabet = "qwertyuiopasdfghjklzxcvbnm" splitBy("")

fun randomString(len) =
  (1 to len map ((n) -> alphabet[randomInt(sizeOf(alphabet) - 1)]) joinBy "")

fun limitTextBy(str: String, size: Number): Array<String> =
    flatten(str scan ".{1,$(size)}")

fun randomPhoneNumber() =
  "+1-" ++ (1 to 3 map ((n) -> randomInt(9)) joinBy "") ++ "-" ++ (1 to 4 map ((n) -> randomInt(9)) joinBy "") ++ "-" ++ (1 to 4 map ((n) -> randomInt(9)) joinBy "")

var firstWords = ["Tech", "Globodyne", "Innovative", "Global", "Digital", "Smart", "Future", "Dynamic"]

var secondWords = ["Solutions", "Systems", "Enterprises", "Consulting", "Services", "Ventures", "Networks"]

fun randomCompanyName() =
  firstWords[randomInt(sizeOf(firstWords)-1)] ++ " " ++ secondWords[randomInt(sizeOf(secondWords)-1)]

var names = ["John", "Alice", "Michael", "Emma", "William", "Sophia", "James", "Olivia", "Benjamin", "Isabella", "Jacob", "Charlotte", "Ethan", "Amelia", "Alexander", "Mia", "Mason", "Harper", "Elijah", "Evelyn"]

fun randomPersonName() =
  names[randomInt(sizeOf(names) - 1)]

var lastNames = ["Smith", "Johnson", "Williams", "Jones", "Brown", "Davis", "Miller", "Wilson", "Moore", "Taylor", "Anderson", "Thomas", "Jackson", "White", "Harris", "Martin", "Thompson", "Garcia", "Martinez", "Robinson"]

fun randomLastName() =
  lastNames[randomInt(sizeOf(lastNames) - 1)]

var domains = ["g.com", "ymail.com", "hmail.com", "oumail.com", "ex.com"]
var usernameLength = 8 // Adjust the length of the username as needed
var username = (1 to usernameLength map ((n) -> alphabet[randomInt(sizeOf(alphabet) - 1)]) joinBy "")
var domain = domains[randomInt(sizeOf(domains) - 1)]

fun randomEmail() =
    username ++ "@" ++ domain

fun randomDUNS() =
  "1" ++ (1 to 8 map ((n) -> randomInt(9)) joinBy "")

fun randomJigsawNumber() =
  (1 to 20 map ((n) -> randomInt(9)) joinBy "")

var alphabetWDigit = "abcdefghijklmnopqrstuvwxyz0123456789"
var jigsawCodeLength = 20 // Adjust the length of the Jigsaw code as needed

fun randomJigsawCode() =
  (1 to jigsawCodeLength map ((n) -> alphabetWDigit[randomInt(sizeOf(alphabet) - 1)]) joinBy "")

var startDate = now() // Start date
var within30Days = (startDate + |P30D|)

var idLength = 12 // Length of the transaction ID
var timestampFormat = "yyyyMMddHHmmssSSS" // Format for the timestamp

fun generateTransactionID() =
  now() as String { format: timestampFormat } ++ (1 to idLength map ((n) -> alphabet[randomInt(sizeOf(alphabet) - 1)]) joinBy "")

fun randomIntInRange(min, max) = round(random() * (max - min) + min) as Number

fun generateRandomIPv4() =
    randomIntInRange(1, 255) ++ "." ++
    randomIntInRange(0, 255) ++ "." ++
    randomIntInRange(0, 255) ++ "." ++
    randomIntInRange(1, 254)

fun randomBoolean() =
    if (random() < 0.5) true else false

var cities = ["New York", "Los Angeles", "Chicago", "Houston", "Phoenix", "Philadelphia", "San Antonio", "San Diego", "Dallas", "San Jose", "Austin", "Jacksonville", "San Francisco", "Columbus", "Indianapolis", "Fort Worth", "Charlotte", "Seattle", "Denver", "Washington"]

fun randomCity() =
  cities[randomInt(sizeOf(cities)-1)]

fun randomLatitude() =
  ((random() * 180) - 90) as String {format: "0.##############"} as Number

fun randomLongitude() =
  ((random() * 360) - 180) as String {format: "0.##############"} as Number

fun randomPostalCode() =
  (floor(random() * 90000) + 10000) as String

var states = ["Alabama", "Alaska", "Arizona", "Arkansas", "California", "Colorado", "Connecticut", "Delaware", "Florida", "Georgia", "Hawaii", "Idaho", "Illinois", "Indiana", "Iowa", "Kansas", "Kentucky", "Louisiana", "Maine", "Maryland", "Massachusetts", "Michigan", "Minnesota", "Mississippi", "Missouri", "Montana", "Nebraska", "Nevada", "New Hampshire", "New Jersey", "New Mexico", "New York", "North Carolina", "North Dakota", "Ohio", "Oklahoma", "Oregon", "Pennsylvania", "Rhode Island", "South Carolina", "South Dakota", "Tennessee", "Texas", "Utah", "Vermont", "Virginia", "Washington", "West Virginia", "Wisconsin", "Wyoming"]

fun randomState() =
  states[floor(random() * sizeOf(states))]

var streetNames = ["Main Street", "Park Avenue", "Broadway", "Elm Street", "Maple Avenue", "Washington Street", "Oak Street", "Pine Street", "Cedar Avenue", "High Street", "Market Street", "Chestnut Street", "Church Street", "Lakeview Drive", "Sunset Boulevard", "Spring Street", "River Road", "Willow Street", "Forest Avenue", "Central Avenue"]

fun randomStreetName() =
  streetNames[round(random() * (sizeOf(streetNames)-1))]

fun randomTLD() =
  ["com", "net", "org", "info", "biz", "io"][randomInt(5)]

fun randomSite() =
  "www." ++ randomString(20) ++ "." ++ randomTLD()
