/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;

public class MonthDayDeserializer
extends JSR310DateTimeDeserializerBase<MonthDay> {
    private static final long serialVersionUID = 1L;
    public static final MonthDayDeserializer INSTANCE = new MonthDayDeserializer();

    public MonthDayDeserializer() {
        this((DateTimeFormatter)null);
    }

    public MonthDayDeserializer(DateTimeFormatter formatter) {
        super(MonthDay.class, formatter);
    }

    protected MonthDayDeserializer(MonthDayDeserializer base, Boolean leniency) {
        super(base, leniency);
    }

    protected MonthDayDeserializer(MonthDayDeserializer base, Boolean leniency, DateTimeFormatter formatter, JsonFormat.Shape shape) {
        super(base, leniency, formatter, shape);
    }

    @Override
    protected MonthDayDeserializer withLeniency(Boolean leniency) {
        return new MonthDayDeserializer(this, leniency);
    }

    protected MonthDayDeserializer withDateFormat(DateTimeFormatter dtf) {
        return new MonthDayDeserializer(this, (Boolean)this._isLenient, dtf, this._shape);
    }

    @Override
    public MonthDay deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(p, ctxt, p.getText());
        }
        if (p.isExpectedStartObjectToken()) {
            String str = ctxt.extractScalarFromObject(p, this, this.handledType());
            if (str != null) {
                return this._fromString(p, ctxt, str);
            }
        } else {
            if (p.isExpectedStartArrayToken()) {
                JsonToken t2 = p.nextToken();
                if (t2 == JsonToken.END_ARRAY) {
                    return null;
                }
                if ((t2 == JsonToken.VALUE_STRING || t2 == JsonToken.VALUE_EMBEDDED_OBJECT) && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    MonthDay parsed = this.deserialize(p, ctxt);
                    if (p.nextToken() != JsonToken.END_ARRAY) {
                        this.handleMissingEndArrayForSingle(p, ctxt);
                    }
                    return parsed;
                }
                if (t2 != JsonToken.VALUE_NUMBER_INT) {
                    this._reportWrongToken(ctxt, JsonToken.VALUE_NUMBER_INT, "month");
                }
                int month = p.getIntValue();
                int day = p.nextIntValue(-1);
                if (day == -1) {
                    if (!p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                        this._reportWrongToken(ctxt, JsonToken.VALUE_NUMBER_INT, "day");
                    }
                    day = p.getIntValue();
                }
                if (p.nextToken() != JsonToken.END_ARRAY) {
                    throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                }
                return MonthDay.of(month, day);
            }
            if (p.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
                return (MonthDay)p.getEmbeddedObject();
            }
        }
        return (MonthDay)this._handleUnexpectedToken(ctxt, p, JsonToken.VALUE_STRING, JsonToken.START_ARRAY);
    }

    protected MonthDay _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        String string = string0.trim();
        if (string.length() == 0) {
            return (MonthDay)this._fromEmptyString(p, ctxt, string);
        }
        try {
            if (this._formatter == null) {
                return MonthDay.parse(string);
            }
            return MonthDay.parse(string, this._formatter);
        }
        catch (DateTimeException e) {
            return (MonthDay)this._handleDateTimeException(ctxt, e, string);
        }
    }
}

