/*
 * Decompiled with CFR 0.152.
 */
package org.connectivity.testgen;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.connectivity.testgen.OperationMethod;
import org.connectivity.testgen.Operations;

public class TreeNode {
    private String path;
    private List<TreeNode> children;
    private Map<OperationMethod, Operations> methods;

    private void prettyPrintTree(StringBuilder sb, String prefix, boolean isTail) {
        sb.append(prefix).append(isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ").append(this.path.isEmpty() ? "/" : this.path).append("\n");
        for (int i = 0; i < this.children.size() - 1; ++i) {
            this.children.get(i).prettyPrintTree(sb, prefix + (isTail ? "    " : "\u2502   "), false);
        }
        if (!this.children.isEmpty()) {
            this.children.get(this.children.size() - 1).prettyPrintTree(sb, prefix + (isTail ? "    " : "\u2502   "), true);
        }
        if (!this.methods.isEmpty()) {
            this.methods.forEach((method, details) -> sb.append(prefix).append(isTail ? "    " : "\u2502   ").append(method).append(": ").append(details).append("\n"));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.prettyPrintTree(sb, "", true);
        return sb.toString();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode> children) {
        this.children = children;
    }

    public Map<OperationMethod, Operations> getMethods() {
        return this.methods;
    }

    public void setMethods(Map<OperationMethod, Operations> methods) {
        this.methods = methods;
    }

    public List<Map<String, TreeNode>> collectPathNodeMaps(TreeNode node, Map<String, TreeNode> pathNodeMap) {
        ArrayList<Map<String, TreeNode>> pathNodeMaps = new ArrayList<Map<String, TreeNode>>();
        if (!node.getPath().isEmpty()) {
            pathNodeMap.put(node.getPath(), node);
            pathNodeMaps.add(new LinkedHashMap<String, TreeNode>(pathNodeMap));
        }
        for (TreeNode child : node.getChildren()) {
            pathNodeMaps.addAll(this.collectPathNodeMaps(child, pathNodeMap));
        }
        if (!node.getPath().isEmpty()) {
            pathNodeMap.remove(node.getPath());
        }
        return pathNodeMaps;
    }
}

