/*
 * Copyright (c) 2025, Salesforce, Inc.,
 * All rights reserved.
 * For full license text, see the LICENSE.txt file
 */
%dw 2.5
import * from dw::test::Asserts
import * from dw::test::Tests
import * from dw::Runtime

import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::transport::Http

import * from com::mulesoft::connectivity::Metadata

type BasicConnection = {
    baseUri: String,
    username: String,
    password: String
}

var basicConnection = {
	baseUri: dw::System::envVars().INTERPRETED_CONNECTIVITY_BASE_URI default "https://domain.subdomain.com/",
    username: dw::System::envVars().INTERPRETED_CONNECTIVITY_USERNAME default "username",
    password: dw::System::envVars().INTERPRETED_CONNECTIVITY_PASSWORD default "password"
}

@ConnectionElement()
var basicAuthConnection = defineBasicHttpConnectionProvider<BasicConnection>(
	(parameter: BasicConnection) -> {username: parameter.username, password: parameter.password},
	(parameter: BasicConnection) ->  {baseUri: parameter.baseUri}
)

var connection = basicAuthConnection.connect(basicConnection)


