/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

/**
 * A Module that provides a privileged API to be used ONLY within a given service.
 */
module org.mule.runtime.additional {

  requires transitive org.mule.runtime.api;

  // exported packages to enforce validation during compilation
  exports org.mule.runtime.additional.api.test to
      org.mule.service.test.lib,
      org.mule.service.test;

  // open packages for jpms-utils to propagate visibility to the service
  opens org.mule.runtime.additional.api.test to
      org.mule.runtime.jpms.utils;
}