%dw 2.8


import ConnectionElement, TestConnectionElement from com::mulesoft::connectivity::Metadata
import defineTestConnection from com::mulesoft::connectivity::Model
import mapInputOperation from com::mulesoft::connectivity::decorator::Operation


import ApiKeyAuthSchema, defineApiKeyHttpConnectionProvider from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::pagerduty::operations::O_users_get

import * from com::mulesoft::connectivity::decorator::Annotations

@TestConnectionElement()
var test = {
  validate: defineTestConnection(mapInputOperation(O_users_get, (param: {}) -> {
    query: {},
    headers: {
    },
    cookie: {}
  }), (response) -> {
    isValid: response.value.status == 200,
    message:
      if (response.success is true)
        "Connection test succeeded"
      else
          if(response.error.value.status?)
              "Connection test failed - Http status code: " ++ response.error.value.status as String
          else
              "Connection test failed",
    (error: if(isEmpty(response.error.value.body.^raw))
                write(response.error.value.body, "application/dw") as String
            else
                response.error.value.body.^raw as String) if (response.success is false and response.error.value.body?)
  })
}


var api_key = defineApiKeyHttpConnectionProvider<ApiKeyAuthSchema & { baseUri: @HelpText(value = "Base URI with the following format: https://api.pagerduty.com") String }>((schema) -> {
                apiKey: schema.apiKey
              }, (schema) -> {
                baseUri: schema.baseUri
              },{
                  in: "header",
                  name: "Authorization"
              })
