%dw 2.8

import Error, Result, ResultFailure, failure, unexpectedFailure, UnexpectedError, success from com::mulesoft::connectivity::Model

import Description from com::mulesoft::connectivity::decorator::Annotations

import T_Reference, T_ScheduleLayer, T_SubSchedule, T_TeamReference from com::mulesoft::connectivity::pagerduty::types::Types

import HttpConnection, HttpRequestType, HttpResponse from com::mulesoft::connectivity::transport::Http

import serializeCookies, serializeHeaders, serializeUriParams, withSerializationConfig from com::mulesoft::connectivity::transport::Serialization

type schedule_put_Type = {
  schedule: {
    id?: String,
    summary?: String | Null,
    "type"?: String,
    self?: String | Null,
    html_url?: String | Null,
    schedule_layers?: Array<T_ScheduleLayer>,
    time_zone: String | Null,
    name?: String,
    description?: String | Null,
    final_schedule?: T_SubSchedule | Null,
    overrides_subschedule?: T_SubSchedule | Null,
    escalation_policies?: Array<T_Reference>,
    users?: Array<T_Reference>,
    teams?: Array<T_TeamReference>
  }
}

type O_schedules__id__put_Type = {
  "200": HttpResponse<schedule_put_Type>,
  "400": HttpResponse<Any>,
  "401": HttpResponse<Any>,
  "403": HttpResponse<Any>,
  "404": HttpResponse<Any>,
  "429": HttpResponse<Any>,
  errorResponse: ResultFailure<O_schedules__id__put_Type."400", Error<"400", "CLIENT_ERROR">> |
                ResultFailure<O_schedules__id__put_Type."401", Error<"401", "CLIENT_ERROR">> |
                ResultFailure<O_schedules__id__put_Type."403", Error<"403", "CLIENT_ERROR">> |
                ResultFailure<O_schedules__id__put_Type."404", Error<"404", "CLIENT_ERROR">> |
                ResultFailure<O_schedules__id__put_Type."429", Error<"429", "CLIENT_ERROR">> |
                ResultFailure<HttpResponse<Any>, UnexpectedError>,
  request: HttpRequestType<{
    uri: { id: String },
    query: { overflow?: Boolean },
    headers: Object,
    cookie: Object,
    body?: {
      schedule: {
        id?: String,
        summary?: String | Null,
        self?: String | Null,
        html_url?: String | Null,
        "type"?: "schedule",
        schedule_layers: Array<T_ScheduleLayer>,
        time_zone: String,
        name?: String,
        description?: String,
        final_schedule?: T_SubSchedule,
        overrides_subschedule?: T_SubSchedule,
        escalation_policies?: Array<T_Reference>,
        users?: Array<T_Reference>,
        teams?: Array<T_TeamReference>
      }
    }
  }>,
  response: O_schedules__id__put_Type."200"
}


var O_schedules__id__put = {
  name: "UpdateSchedule",
  displayName: "Update Schedule",
  executor: (parameter: O_schedules__id__put_Type.request, connection: HttpConnection): Result<O_schedules__id__put_Type.response, O_schedules__id__put_Type.errorResponse> -> do {
      var uri = serializeUriParams(parameter.uri, {})
      var query = parameter.query default {} withSerializationConfig {}
      var headers = serializeHeaders(parameter.headers default {}, {})
      var cookie = serializeCookies(parameter.cookie default {}, {})
      var response = connection({
        method: "PUT",
        path: "/schedules/$(uri.id)",
        queryParams: query,
        headers: headers ++{"Accept": "application/json", "Content-Type":"application/json"},
        config: {
          contentType: "application/json"
        },
        cookie: cookie,
        (body: parameter.body) if (parameter.body?)
      })
      ---
      response match {
        case response200 if response200.status == 200 -> success(response200 as O_schedules__id__put_Type."200")
        case response400 if response400.status == 400 -> failure(response400, {
          kind: "400",
          categories: ["CLIENT_ERROR"]
        }, "Caller provided invalid arguments. Please review the response for error details. Retrying with the same arguments will *not* work.")
        case response401 if response401.status == 401 -> failure(response401, {
          kind: "401",
          categories: ["CLIENT_ERROR"]
        }, "Caller did not supply credentials or did not provide the correct credentials.\nIf you are using an API key, it may be invalid or your Authorization header may be malformed.\n")
        case response403 if response403.status == 403 -> failure(response403, {
          kind: "403",
          categories: ["CLIENT_ERROR"]
        }, "Caller is not authorized to view the requested resource.\nWhile your authentication is valid, the authenticated user or token does not have permission to perform this action.\n")
        case response404 if response404.status == 404 -> failure(response404, {
          kind: "404",
          categories: ["CLIENT_ERROR"]
        }, "The requested resource was not found.")
        case response429 if response429.status == 429 -> failure(response429, {
          kind: "429",
          categories: ["CLIENT_ERROR"]
        }, "Too many requests have been made, the rate limit has been reached.")
        else responsedefault-> unexpectedFailure(responsedefault, {
          kind: response.status as String,
          categories: []
        })
      }
    }
}

