%dw 2.8

import Error, Result, ResultFailure, failure, unexpectedFailure, UnexpectedError, success from com::mulesoft::connectivity::Model

import HttpConnection, HttpRequestType, HttpResponse, NoContentHttpResponse from com::mulesoft::connectivity::transport::Http

import serializeCookies, serializeHeaders, serializeUriParams, withSerializationConfig from com::mulesoft::connectivity::transport::Serialization

type O_services__id__delete_Type = {
  "204": NoContentHttpResponse,
  "401": HttpResponse<Any>,
  "403": HttpResponse<Any>,
  errorResponse: ResultFailure<O_services__id__delete_Type."401", Error<"401", "CLIENT_ERROR">> | ResultFailure<O_services__id__delete_Type."403", Error<"403", "CLIENT_ERROR">> | ResultFailure<HttpResponse<Any>, UnexpectedError>,
  request: HttpRequestType<{| uri: {| id: String |}, query: Object, headers: Object, cookie: Object |}>,
  response: O_services__id__delete_Type."204"
}

var O_services__id__delete = {
  name: "DeleteService",
  displayName: "Delete Service",
  executor: (parameter: O_services__id__delete_Type.request, connection: HttpConnection): Result<O_services__id__delete_Type.response, O_services__id__delete_Type.errorResponse> -> do {
      var uri = serializeUriParams(parameter.uri, {})
      var query = parameter.query default {} withSerializationConfig {}
      var headers = serializeHeaders(parameter.headers default {}, {})
      var cookie = serializeCookies(parameter.cookie default {}, {})
      var response = connection({
        method: "DELETE",
        path: "/services/$(uri.id)",
        queryParams: query,
        headers: headers ++{"Accept": "application/json", "Content-Type":"application/json"},
        cookie: cookie,
        (body: parameter.body) if (parameter.body?)
      })
      ---
      response match {
        case response204 if response204.status == 204 -> success(response204 as O_services__id__delete_Type."204")
        case response401 if response401.status == 401 -> failure(response401, {
          kind: "401",
          categories: ["CLIENT_ERROR"]
        }, "Caller did not supply credentials or did not provide the correct credentials.\nIf you are using an API key, it may be invalid or your Authorization header may be malformed.\n")
        case response403 if response403.status == 403 -> failure(response403, {
          kind: "403",
          categories: ["CLIENT_ERROR"]
        }, "Caller is not authorized to view the requested resource.\nWhile your authentication is valid, the authenticated user or token does not have permission to perform this action.\n")
        else responsedefault-> unexpectedFailure(responsedefault, {
          kind: response.status as String,
          categories: []
        })
      }
    }
}

