%dw 2.8

import Error, Result, ResultFailure, failure, unexpectedFailure, UnexpectedError, success from com::mulesoft::connectivity::Model

import Integer, LWDateTime from com::mulesoft::connectivity::Types

import Description, Label from com::mulesoft::connectivity::decorator::Annotations

import T_AddonReference, T_AlertGroupingParameters, T_AutoPauseNotificationsParameters, T_IncidentUrgencyRule, T_IntegrationReference, T_Pagination, T_Reference, T_ScheduledAction, T_SupportHours, T_TeamReference from com::mulesoft::connectivity::pagerduty::types::Types

import HttpConnection, HttpRequestType, HttpResponse from com::mulesoft::connectivity::transport::Http

import serializeCookies, serializeHeaders, withSerializationConfig from com::mulesoft::connectivity::transport::Serialization

type services_get_Type = T_Pagination & {
  services: Array<{
    id?: String,
    summary?: String | Null,
    "type"?: String,
    self?: String | Null,
    html_url?: String | Null,
    name?: String,
    description?: String | Null,
    auto_resolve_timeout?: Integer | Null,
    acknowledgement_timeout?: Integer | Null,
    created_at?: LWDateTime,
    status?: "active" | "warning" | "critical" | "maintenance" | "disabled",
    last_incident_timestamp?: LWDateTime,
    escalation_policy: T_Reference ,
    response_play?: T_Reference  | Null,
    teams?: Array<T_TeamReference>,
    integrations?: Array<T_IntegrationReference>,
    incident_urgency_rule?: T_IncidentUrgencyRule | Null,
    support_hours?: T_SupportHours | Null,
    scheduled_actions?: Array<T_ScheduledAction>,
    addons?: Array<T_AddonReference>,
    alert_creation?: "create_incidents" | "create_alerts_and_incidents" | Null,
    alert_grouping_parameters?: T_AlertGroupingParameters | Null,
    alert_grouping?: "time" | "intelligent" | Null,
    alert_grouping_timeout?: Integer | Null,
    auto_pause_notifications_parameters?: T_AutoPauseNotificationsParameters | Null
  }>
}

type O_services_get_Type = {
  "200": HttpResponse<services_get_Type>,
  "400": HttpResponse<Any>,
  "401": HttpResponse<Any>,
  "403": HttpResponse<Any>,
  errorResponse: ResultFailure<O_services_get_Type."400", Error<"400", "CLIENT_ERROR">> | ResultFailure<O_services_get_Type."401", Error<"401", "CLIENT_ERROR">> | ResultFailure<O_services_get_Type."403", Error<"403", "CLIENT_ERROR">> | ResultFailure<HttpResponse<Any>, UnexpectedError>,
  request: HttpRequestType<{| query: { query?: String, limit?: Integer, offset?: Integer, total?: Boolean, "team_ids[]"?: Array<String>, time_zone?: String, sort_by?: "name" | "name:asc" | "name:desc", "include[]"?: "escalation_policies" | "teams" | "integrations" | "auto_pause_notifications_parameters" }, headers: Object, cookie: Object |}>,
  response: O_services_get_Type."200"
}


var O_services_get = {
  name: "ListServices",
  displayName: "List Services",
  executor: (parameter: O_services_get_Type.request, connection: HttpConnection): Result<O_services_get_Type.response, O_services_get_Type.errorResponse> -> do {
      var query = parameter.query default {} withSerializationConfig {}
      var headers = serializeHeaders(parameter.headers default {}, {})
      var cookie = serializeCookies(parameter.cookie default {}, {})
      var response = connection({
        method: "GET",
        path: "/services",
        queryParams: query,
        headers: headers ++{"Accept": "application/json", "Content-Type":"application/json"},
        cookie: cookie,
        (body: parameter.body) if (parameter.body?)
      })
      ---
      response match {
        case response200 if response200.status == 200 -> success(response200 as O_services_get_Type."200")
        case response400 if response400.status == 400 -> failure(response400, {
          kind: "400",
          categories: ["CLIENT_ERROR"]
        }, "Caller provided invalid arguments. Please review the response for error details. Retrying with the same arguments will *not* work.")
        case response401 if response401.status == 401 -> failure(response401, {
          kind: "401",
          categories: ["CLIENT_ERROR"]
        }, "Caller did not supply credentials or did not provide the correct credentials.\nIf you are using an API key, it may be invalid or your Authorization header may be malformed.\n")
        case response403 if response403.status == 403 -> failure(response403, {
          kind: "403",
          categories: ["CLIENT_ERROR"]
        }, "Caller is not authorized to view the requested resource.\nWhile your authentication is valid, the authenticated user or token does not have permission to perform this action.\n")
        else responsedefault-> unexpectedFailure(responsedefault, {
          kind: response.status as String,
          categories: []
        })
      }
    }
}

