%dw 2.8

import Number, Integer, LWDateTime from com::mulesoft::connectivity::Types

import Description, Label from com::mulesoft::connectivity::decorator::Annotations

type T_User = {
  id?: String,
  summary?: String | Null,
  "type": String,
  self?: String | Null,
  html_url?: String | Null,
  name: String,
  email: String,
  time_zone?: String,
  color?: String,
  role?: "admin" | "limited_user" | "observer" | "owner" | "read_only_user" | "restricted_access" | "read_only_limited_user" | "user",
  avatar_url?: String,
  description?: String | Null,
  invitation_sent?: Boolean,
  job_title?: String | Null,
  teams?: Array<T_TeamReference>,
  contact_methods?: Array<T_ContactMethodReference>,
  notification_rules?: Array<T_NotificationRuleReference>
}

type T_LicenseReference = {
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null
}

type T_ScheduleLayer = {
  id?: String,
  start: LWDateTime,
  end?: LWDateTime | Null,
  users: Array<T_ScheduleLayerUser>,
  restrictions?: Array<T_Restriction>,
  rotation_virtual_start: LWDateTime,
  rotation_turn_length_seconds: Number,
  name?: String,
  rendered_schedule_entries?: Array<T_ScheduleLayerEntry>,
  rendered_coverage_percentage?: Number | Null
}

type T_SubSchedule = {
  name: "Final Schedule" | "Overrides",
  rendered_schedule_entries?: Array<T_ScheduleLayerEntry>,
  rendered_coverage_percentage?: Number | Null
}

type T_Reference = {
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null
}

type T_TeamReference = {
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null
}

type T_EscalationRule = {
  id?: String,
  escalation_delay_in_minutes: Number,
  targets: Array<T_EscalationTargetReference>,
  escalation_rule_assignment_strategy?: "round_robin" | "assign_to_everyone"
}

type T_IntegrationReference = T_Reference

type T_IncidentUrgencyRule = {
  during_support_hours?: T_IncidentUrgencyType,
  outside_support_hours?: T_IncidentUrgencyType,
  "type"?: "constant" | "use_support_hours",
  urgency?: "low" | "high" | "severity_based"
}

type T_SupportHours = {
  "type"?: "fixed_time_per_day",
  time_zone?: String,
  days_of_week?: Array<Number>,
  start_time?: String,
  end_time?: String
}

type T_ScheduledAction = {
  "type": "urgency_change",
  at: {
    "type": "named_time",
    name: "support_hours_start" | "support_hours_end"
  },
  to_urgency: "high"
}

type T_AddonReference = {
  src?: String,
  name?: String,
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null
}

type T_AlertGroupingParameters = {
  "type"?: "time" | "intelligent" | "content_based" | Null,
  config?: {
    time_window?: Number,
    recommended_time_window?: Number,
    timeout?: Number,
    aggregate?: "all" | "any",
    fields?: Array<String>,
  } | Null
}

type T_AutoPauseNotificationsParameters = {
  enabled?: Boolean,
  timeout?: Number
}

type T_ContactMethodReference = {
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null
}

type T_NotificationRuleReference = {
  "type"?: "assignment_notification_rule_reference",
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null
}

type T_ScheduleLayerUser = {
  user:  {
    id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null
  }
}

type T_Restriction = {
  "type": "daily_restriction" | "weekly_restriction",
  duration_seconds: Number,
  start_time_of_day: String,
  start_day_of_week?: Number
}

type T_ScheduleLayerEntry = {
  user?: {
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null
},
  start: LWDateTime,
  end: LWDateTime
}

type T_EscalationTargetReference = T_Reference 
type T_IncidentUrgencyType = {
  "type"?: "constant" | "use_support_hours",
  urgency?: "low" | "high" | "severity_based"
}

type T_TimeBasedAlertGroupingConfiguration = {
  timeout?: Number
}

type T_ContentBasedAlertGroupingConfiguration = {
  aggregate?: "all" | "any",
  fields?: Array<String>,
  time_window?: Number,
  recommended_time_window?: Number
}

type T_Pagination = {
  offset?: Number,
  limit?: Number,
  more?: Boolean,
  total?: Number | Null
}

/*

this one is after manual changes
type T_Incident = {
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null,
  description?: String | Null,
  incident_number?: Number,
  title?: String,
  created_at?: LWDateTime,
  updated_at?: LWDateTime | Null,
  status?: "triggered" | "acknowledged" | "resolved",
  incident_key?: String,
  service?: {
    id?: String,
    summary?: String | Null,
    "type"?: String,
    self?: String | Null,
    html_url?: String | Null,
    name?: String | Null,
    description?: String | Null,
    auto_resolve_timeout?: Number | Null,
    acknowledgement_timeout?: Number,
    created_at?: LWDateTime,
    status?: "active" | "warning" | "critical" | "maintenance" | "disabled",
    last_incident_timestamp?: LWDateTime,
    escalation_policy?: T_Reference,
    response_play?: T_Reference,
    teams?: Array<T_TeamReference>,
    integrations?: Array<T_IntegrationReference>,
    incident_urgency_rule?: T_IncidentUrgencyRule,
    support_hours?: T_SupportHours | Null,
    scheduled_actions?: Array<T_ScheduledAction>,
    addons?: Array<T_AddonReference>,
    alert_creation?: "create_incidents" | "create_alerts_and_incidents",
    alert_grouping_parameters?: T_AlertGroupingParameters,
    alert_grouping?: "time" | "intelligent" | Null,
    alert_grouping_timeout?: Number | Null,
    auto_pause_notifications_parameters?: T_AutoPauseNotificationsParameters
  },
  assignments?: Array<T_Assignment>,
  assigned_via?: "escalation_policy" | "direct_assignment",
  last_status_change_at?: LWDateTime | Null,
  resolved_at?: LWDateTime | Null,
  first_trigger_log_entry?: T_TriggerLogEntry,
  alert_counts?: T_AlertCount,
  is_mergeable?: Boolean,
  basic_alert_grouping?: String | Null,
  escalation_policy?:  {
    id?: String,
    summary?: String | Null,
    "type"?: String,
    self?: String | Null,
    html_url?: String | Null,
    name?: String,
    description?: String | Null,
    num_loops?: Number | Null,
    on_call_handoff_notifications?: "if_has_services" | "always",
    escalation_rules?: Array<T_EscalationRule>,
    services?: Array<T_Reference>,
    teams?: Array<T_TeamReference>
  },
  teams?: Array<T_Team>,
  pending_actions?: Array<T_IncidentAction>,
  acknowledgements?: Array<T_Acknowledgement>,
  alert_grouping?: {
    grouping_type?: "basic" | "advanced" | "rules",
    started_at?: LWDateTime,
    ended_at?: LWDateTime | Null,
    alert_grouping_active?: Boolean
  } | Null,
  last_status_change_by?: {
    id?: String,
    summary?: String | Null,
    "type"?: String,
    self?: String | Null,
    html_url?: String | Null,
    name?: String,
    description?: String | Null,
    auto_resolve_timeout?: Number | Null,
    acknowledgement_timeout?: Number | Null,
    created_at?: LWDateTime,
    status?: "active" | "warning" | "critical" | "maintenance" | "disabled",
    last_incident_timestamp?: LWDateTime,
    escalation_policy?: T_Reference ,
    response_play?: T_Reference ,
    teams?: Array<T_TeamReference>,
    integrations?: Array<T_IntegrationReference>,
    incident_urgency_rule?: T_IncidentUrgencyRule,
    support_hours?: T_SupportHours,
    scheduled_actions?: Array<T_ScheduledAction>,
    addons?: Array<T_AddonReference>,
    alert_creation?: "create_incidents" | "create_alerts_and_incidents",
    alert_grouping_parameters?: T_AlertGroupingParameters,
    alert_grouping?: "time" | "intelligent"| Null,
    alert_grouping_timeout?: Number | Null,
    auto_pause_notifications_parameters?: T_AutoPauseNotificationsParameters,
    impacted_services?: Array<T_Reference>,
    email?: String,
    time_zone?: String | Null,
    color?: String | Null,
    role?: "admin" | "limited_user" | "observer" | "owner" | "read_only_user" | "restricted_access" | "read_only_limited_user" | "user",
    avatar_url?: String | Null,
    description?: String | Null,
    invitation_sent?: Boolean,
    job_title?: String | Null,
    teams?: Array<T_TeamReference>,
    contact_methods?: Array<T_ContactMethodReference>,
    notification_rules?: Array<T_NotificationRuleReference> 
  },
  priority?: T_Priority | Null,
  resolve_reason?: T_ResolveReason | Null,
  conference_bridge?: {
    conference_number?: String | Null,
    conference_url?: String | Null
  },
  incidents_responders?: Array<T_IncidentsRespondersReference>,
  responder_requests?: Array<T_ResponderRequest>,
  subscriber_requests?: Array<Object>,
  urgency?: "high" | "low",
  body?: {
    details?: Object,
    "type": String
  }
}
*/
/*

this one works!!!!
type T_Incident = {
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null
} & {
  incident_number?: Number,
  title?: String,
  created_at?: LWDateTime,
  updated_at?: LWDateTime,
  status?: "triggered" | "acknowledged" | "resolved",
  incident_key?: String,
  service?: T_Reference & {
    "type"?: "service_reference"
  } | {
    id?: String,
    summary?: String | Null,
    "type"?: String,
    self?: String | Null,
    html_url?: String | Null
  } & {
    "type": "service",
    name?: String | Null,
    description?: String | Null,
    auto_resolve_timeout?: Number | Null,
    acknowledgement_timeout?: Number,
    created_at?: LWDateTime,
    status?: "active" | "warning" | "critical" | "maintenance" | "disabled",
    last_incident_timestamp?: LWDateTime,
    escalation_policy: T_Reference & {
      "type"?: "escalation_policy_reference"
    },
    response_play?: T_Reference & {
      "type"?: "response_play_reference"
    },
    teams?: Array<T_TeamReference>,
    integrations?: Array<T_IntegrationReference>,
    incident_urgency_rule?: T_IncidentUrgencyRule,
    support_hours?: T_SupportHours | Null,
    scheduled_actions?: Array<T_ScheduledAction>,
    addons?: Array<T_AddonReference>,
    alert_creation?: "create_incidents" | "create_alerts_and_incidents",
    alert_grouping_parameters?: T_AlertGroupingParameters,
    alert_grouping?: "time" | "intelligent" | Null,
    alert_grouping_timeout?: Number | Null,
    auto_pause_notifications_parameters?: T_AutoPauseNotificationsParameters
  },
  assignments?: Array<T_Assignment>,
  assigned_via?: "escalation_policy" | "direct_assignment",
  last_status_change_at?: LWDateTime,
  resolved_at?: LWDateTime | Null,
  first_trigger_log_entry?: T_LogEntryReference | T_TriggerLogEntry,
  alert_counts?: T_AlertCount,
  is_mergeable?: Boolean,
  basic_alert_grouping?: String | Null,
  escalation_policy?: T_Reference & {
    "type"?: "escalation_policy_reference"
  } | {
    id?: String,
    summary?: String | Null,
    "type"?: String,
    self?: String | Null,
    html_url?: String | Null
  } & {
    "type": "escalation_policy",
    name: String,
    description?: String,
    num_loops?: Number | Null,
    on_call_handoff_notifications?: "if_has_services" | "always",
    escalation_rules: Array<T_EscalationRule>,
    services?: Array<T_Reference & { "type"?: "service_reference" }>,
    teams?: Array<T_TeamReference>
  },
  teams?: Array<T_TeamReference | T_Team>,
  pending_actions?: Array<T_IncidentAction>,
  acknowledgements?: Array<T_Acknowledgement>,
  alert_grouping?: {
    grouping_type?: "basic" | "advanced" | "rules",
    started_at?: LWDateTime,
    ended_at?: LWDateTime | Null,
    alert_grouping_active?: Boolean
  } | Null,
  last_status_change_by?: T_AgentReference | T_User | {
    id?: String,
    summary?: String | Null,
    "type"?: String,
    self?: String | Null,
    html_url?: String | Null
  } & {
    "type": "service",
    name?: String,
    description?: String,
    auto_resolve_timeout?: Number,
    acknowledgement_timeout?: Number,
    created_at?: LWDateTime,
    status?: "active" | "warning" | "critical" | "maintenance" | "disabled",
    last_incident_timestamp?: LWDateTime,
    escalation_policy: T_Reference & {
      "type"?: "escalation_policy_reference"
    },
    response_play?: T_Reference & {
      "type"?: "response_play_reference"
    },
    teams?: Array<T_TeamReference>,
    integrations?: Array<T_IntegrationReference>,
    incident_urgency_rule?: T_IncidentUrgencyRule,
    support_hours?: T_SupportHours,
    scheduled_actions?: Array<T_ScheduledAction>,
    addons?: Array<T_AddonReference>,
    alert_creation?: "create_incidents" | "create_alerts_and_incidents",
    alert_grouping_parameters?: T_AlertGroupingParameters,
    alert_grouping?: "time" | "intelligent"| Null,
    alert_grouping_timeout?: Number | Null,
    auto_pause_notifications_parameters?: T_AutoPauseNotificationsParameters,
    impacted_services?: Array<T_Reference>
  },
  priority?: T_Priority | Null,
  resolve_reason?: T_ResolveReason | Null,
  conference_bridge?: {
    conference_number?: String,
    conference_url?: String
  },
  incidents_responders?: Array<T_IncidentsRespondersReference>,
  responder_requests?: Array<T_ResponderRequest>,
  subscriber_requests?: Array<Object>,
  urgency?: "high" | "low",
  body?: {
    details?: Object,
    "type": String
  }
}
*/


/* this is chatgpt one 
type T_Incident = {
  id?: String,
  summary?: String | Null,
  self?: String | Null,
  html_url?: String | Null,
  incident_number?: Number,
  title?: String,
  description?: String | Null,
  "type"?: String,
  created_at?: LWDateTime,
  updated_at?: LWDateTime,
  status?: "triggered" | "acknowledged" | "resolved",
  incident_key?: String,
  service?: {
    id?: String,
    summary?: String | Null,
    self?: String | Null,
    html_url?: String | Null,
    name?: String | Null,
    description?: String | Null,
    auto_resolve_timeout?: Number | Null,
    acknowledgement_timeout?: Number,
    created_at?: LWDateTime,
    status?: "active" | "warning" | "critical" | "maintenance" | "disabled",
    last_incident_timestamp?: LWDateTime,
    escalation_policy: T_Reference,
    response_play?: T_Reference,
    teams?: Array<T_TeamReference>,
    integrations?: Array<T_IntegrationReference>,
    incident_urgency_rule?: T_IncidentUrgencyRule,
    support_hours?: T_SupportHours | Null,
    scheduled_actions?: Array<T_ScheduledAction>,
    addons?: Array<T_AddonReference>,
    alert_creation?: "create_incidents" | "create_alerts_and_incidents",
    alert_grouping_parameters?: T_AlertGroupingParameters,
    alert_grouping?: "time" | "intelligent" | Null,
    alert_grouping_timeout?: Number | Null,
    auto_pause_notifications_parameters?: T_AutoPauseNotificationsParameters,
    "type"?: String
  },
  assignments?: Array<T_Assignment>,
  assigned_via?: "escalation_policy" | "direct_assignment",
  last_status_change_at?: LWDateTime,
  resolved_at?: LWDateTime | Null,
  first_trigger_log_entry?:  T_TriggerLogEntry,
  alert_counts?: T_AlertCount,
  is_mergeable?: Boolean,
  basic_alert_grouping?: String | Null,
  escalation_policy?: {
    id?: String,
    summary?: String | Null,
    self?: String | Null,
    html_url?: String | Null,
    name?: String,
    description?: String,
    num_loops?: Number | Null,
    on_call_handoff_notifications?: "if_has_services" | "always",
    escalation_rules?: Array<T_EscalationRule>,
    services?: Array<T_Reference>,
    teams?: Array<T_TeamReference>,
    "type"?: String
  },
  teams?: Array<T_Team>,
  pending_actions?: Array<T_IncidentAction>,
  acknowledgements?: Array<T_Acknowledgement>,
  alert_grouping?: {
    grouping_type?: "basic" | "advanced" | "rules",
    started_at?: LWDateTime,
    ended_at?: LWDateTime | Null,
    alert_grouping_active?: Boolean
  } | Null,
  last_status_change_by?: {
    "type"?: String,
    id?: String,
    summary?: String | Null,
    self?: String | Null,
    html_url?: String | Null,
    name?: String,
    description?: String,
    auto_resolve_timeout?: Number,
    acknowledgement_timeout?: Number,
    created_at?: LWDateTime,
    status?: "active" | "warning" | "critical" | "maintenance" | "disabled",
    last_incident_timestamp?: LWDateTime,
    escalation_policy: T_Reference,
    response_play?: T_Reference,
    teams?: Array<T_TeamReference>,
    integrations?: Array<T_IntegrationReference>,
    incident_urgency_rule?: T_IncidentUrgencyRule,
    support_hours?: T_SupportHours,
    scheduled_actions?: Array<T_ScheduledAction>,
    addons?: Array<T_AddonReference>,
    alert_creation?: "create_incidents" | "create_alerts_and_incidents",
    alert_grouping_parameters?: T_AlertGroupingParameters,
    alert_grouping?: "time" | "intelligent" | Null,
    alert_grouping_timeout?: Number | Null,
    auto_pause_notifications_parameters?: T_AutoPauseNotificationsParameters,
    impacted_services?: Array<T_Reference>
  },
  priority?: T_Priority | Null,
  resolve_reason?: T_ResolveReason | Null,
  conference_bridge?: {
    conference_number?: String,
    conference_url?: String
  },
  incidents_responders?: Array<T_IncidentsRespondersReference>,
  responder_requests?: Array<T_ResponderRequest>,
  subscriber_requests?: Array<Object>,
  urgency?: "high" | "low",
  impacted_services?: Array<T_Reference>,
  body?: {
    details?: Object,
    "type"?: String
  }
}
*/

/**escaltion wala worked sericve worked fine, */
type T_Incident = {
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null
} & {
  incident_number?: Number,
  title?: String,
  created_at?: LWDateTime,
  updated_at?: LWDateTime,
  status?: "triggered" | "acknowledged" | "resolved",
  incident_key?: String,
  service?: {
    id?: String,
    summary?: String | Null,
    "type"?: String,
    self?: String | Null,
    html_url?: String | Null,
    name?: String | Null,
    description?: String | Null,
    auto_resolve_timeout?: Number | Null,
    acknowledgement_timeout?: Number | Null,
    created_at?: LWDateTime,
    updated_at?: LWDateTime,
    status?: "active" | "warning" | "critical" | "maintenance" | "disabled",
    last_incident_timestamp?: LWDateTime | Null,
    escalation_policy?: T_Reference | Null,
    response_play?: T_Reference  | Null,
    teams?: Array<T_Team>,
    integrations?: Array<T_IntegrationReference>,
    incident_urgency_rule?: T_IncidentUrgencyRule,
    support_hours?: T_SupportHours | Null,
    scheduled_actions?: Array<T_ScheduledAction>,
    addons?: Array<T_AddonReference>,
    alert_creation?: "create_incidents" | "create_alerts_and_incidents",
    alert_grouping_parameters?: T_AlertGroupingParameters,
    alert_grouping?: "time" | "intelligent" | Null,
    alert_grouping_timeout?: Number | Null,
    auto_pause_notifications_parameters?: T_AutoPauseNotificationsParameters
  },
  assignments?: Array<T_Assignment>,
  assigned_via?: "escalation_policy" | "direct_assignment",
  last_status_change_at?: LWDateTime,
  resolved_at?: LWDateTime | Null,
  first_trigger_log_entry?:  T_TriggerLogEntry,
  alert_counts?: T_AlertCount,
  is_mergeable?: Boolean,
  basic_alert_grouping?: String | Null,
  escalation_policy?: {
    id?: String,
    summary?: String | Null,
    "type"?: String,
    self?: String | Null,
    html_url?: String | Null,
    name?: String,
    description?: String | Null,
    num_loops?: Integer,
    on_call_handoff_notifications?: "if_has_services" | "always",
    escalation_rules?: Array<T_EscalationRule>,
    services?: Array<T_Reference>,
    teams?: Array<T_TeamReference>,
    privilege?: String | Null
  },
  teams?: Array<T_Team>,
  pending_actions?: Array<T_IncidentAction>,
  acknowledgements?: Array<T_Acknowledgement>,
  alert_grouping?: {
    grouping_type?: "basic" | "advanced" | "rules",
    started_at?: LWDateTime,
    ended_at?: LWDateTime | Null,
    alert_grouping_active?: Boolean
  } | Null,
  last_status_change_by?: {
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null,
  email?: String,
  time_zone?: String,
  color?: String,
  role?: "admin" | "limited_user" | "observer" | "owner" | "read_only_user" | "restricted_access" | "read_only_limited_user" | "user",
  avatar_url?: String,
  invitation_sent?: Boolean,
  job_title?: String | Null,
  contact_methods?: Array<T_ContactMethodReference>,
  notification_rules?: Array<T_NotificationRuleReference>,
  name?: String | Null,
    description?: String | Null,
    auto_resolve_timeout?: Number | Null,
    acknowledgement_timeout?: Number | Null,
    created_at?: LWDateTime,
    updated_at?: LWDateTime,
    status?: "active" | "warning" | "critical" | "maintenance" | "disabled",
    last_incident_timestamp?: LWDateTime | Null,
    escalation_policy?: T_Reference | Null,
    response_play?: T_Reference  | Null,
    teams?: Array<T_Team>,
    integrations?: Array<T_IntegrationReference>,
    incident_urgency_rule?: T_IncidentUrgencyRule,
    support_hours?: T_SupportHours | Null,
    scheduled_actions?: Array<T_ScheduledAction>,
    addons?: Array<T_AddonReference>,
    alert_creation?: "create_incidents" | "create_alerts_and_incidents",
    alert_grouping_parameters?: T_AlertGroupingParameters,
    alert_grouping?: "time" | "intelligent" | Null,
    alert_grouping_timeout?: Number | Null,
    auto_pause_notifications_parameters?: T_AutoPauseNotificationsParameters
  },
  priority?: T_Priority | Null,
  resolve_reason?: T_ResolveReason | Null,
  conference_bridge?: {
    conference_number?: String,
    conference_url?: String
  },
  incidents_responders?: Array<T_IncidentsRespondersReference>,
  responder_requests?: Array<T_ResponderRequest>,
  subscriber_requests?: Array<Object>,
  urgency?: "high" | "low",
  body?: {
    details?: Object,
    "type": String
  }
}
type T_Assignment = {
  at: LWDateTime,
  assignee: T_User 
}

type T_LogEntryReference ={
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null
}

type T_TriggerLogEntry = T_LogEntry

type T_AlertCount = {
  triggered?: Number,
  resolved?: Number,
  all?: Number
}

type T_Team = {
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null,
  name?: String,
  description?: String,
  default_role?: "manager" | "none"
}

type T_IncidentAction = {
  "type": "unacknowledge" | "escalate" | "resolve" | "urgency_change",
  at: LWDateTime,
  to?: "high"
}

type T_Acknowledgement = {
  at: LWDateTime,
  acknowledger: {
    id?: String,
    summary?: String | Null,
    "type"?: String,
    self?: String | Null,
    html_url?: String | Null,
    "type": "service",
    name?: String,
    auto_resolve_timeout?: Number,
    acknowledgement_timeout?: Number,
    created_at?: LWDateTime,
    status?: "active" | "warning" | "critical" | "maintenance" | "disabled",
    last_incident_timestamp?: LWDateTime,
    escalation_policy?: T_Reference,
    response_play?: T_Reference,
    teams?: Array<T_TeamReference>,
    integrations?: Array<T_IntegrationReference>,
    incident_urgency_rule?: T_IncidentUrgencyRule,
    support_hours?: T_SupportHours,
    scheduled_actions?: Array<T_ScheduledAction>,
    addons?: Array<T_AddonReference>,
    alert_creation?: "create_incidents" | "create_alerts_and_incidents",
    alert_grouping_parameters?: T_AlertGroupingParameters,
    alert_grouping?: "time" | "intelligent" | Null,
    alert_grouping_timeout?: Number | Null,
    auto_pause_notifications_parameters?: T_AutoPauseNotificationsParameters,
    email?: String,
    time_zone?: String,
    color?: String,
    role?: "admin" | "limited_user" | "observer" | "owner" | "read_only_user" | "restricted_access" | "read_only_limited_user" | "user",
    avatar_url?: String,
    description?: String | Null,
    invitation_sent?: Boolean,
    job_title?: String | Null,
    contact_methods?: Array<T_ContactMethodReference>,
    notification_rules?: Array<T_NotificationRuleReference>
  }
}

type T_AgentReference = {
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null
}

type T_Priority = {
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null,
  name?: String,
  description?: String
}

type T_ResolveReason = {
  "type"?: "merge_resolve_reason",
  incident?: T_IncidentReference
}

type T_IncidentsRespondersReference = {
  state?: String,
  user?: T_Reference,
  incident?: T_IncidentReference,
  updated_at?: String,
  message?: String,
  requester?: T_Reference,
  requested_at?: String
}

type T_ResponderRequest = {
  incident?: T_IncidentReference,
  requester?: T_Reference,
  requested_at?: String,
  message?: String,
  responder_request_targets?: Array<T_ResponderRequestTargetReference>
}

type T_LogEntry = {
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null,
  created_at?: LWDateTime,
  channel?: T_Channel,
  agent?: T_AgentReference,
  note?: String,
  contexts?: Array<T_Context>,
  service?: T_Reference,
  incident?: T_IncidentReference,
  teams?: Array<T_TeamReference>,
  event_details?: {
    description?: String
  }
}

type T_AcknowledgerReference = {
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null
}

type T_IncidentReference = {
  id?: String,
  summary?: String | Null,
  "type"?: String,
  self?: String | Null,
  html_url?: String | Null
}

type T_ResponderRequestTargetReference = {
  "type"?: String,
  id?: String,
  summary?: String,
  incident_responders?: Array<T_IncidentsRespondersReference>
}

type T_Channel = {
  "type": String,
  user?: Object,
  team?: Object,
  notification?: T_Notification,
  channel?: Object
}

type T_Context = {
  "type": "link" | "image",
  href?: String,
  src?: String,
  text?: String
}

type T_Notification = {
  id?: String,
  "type"?: "sms_notification" | "email_notification" | "phone_notification" | "push_notification",
  started_at?: LWDateTime,
  address?: String,
  user?: T_Reference,
  conferenceAddress?: String,
  status?: String
}
