%dw 2.8

import Error, Result, ResultFailure, failure, unexpectedFailure, UnexpectedError, success from com::mulesoft::connectivity::Model

import Integer from com::mulesoft::connectivity::Types

import Description from com::mulesoft::connectivity::decorator::Annotations

import T_EscalationRule, T_Reference, T_TeamReference from com::mulesoft::connectivity::pagerduty::types::Types

import HttpConnection, HttpRequestType, HttpResponse from com::mulesoft::connectivity::transport::Http

import serializeCookies, serializeHeaders, withSerializationConfig from com::mulesoft::connectivity::transport::Serialization

type escalation_policy_post_Type = {
  escalation_policy: {
    id?: String,
    summary?: String | Null,
    "type"?: String,
    self?: String | Null,
    html_url?: String | Null,
    name?: String,
    description?: String | Null,
    num_loops?: Integer | Null,
    on_call_handoff_notifications?: "if_has_services" | "always"  | Null,
    escalation_rules: Array<T_EscalationRule>,
    services?: Array<T_Reference >,
    teams?: Array<T_TeamReference>
  }
}

type O_escalation_policies_post_Type = {
  "201": HttpResponse<escalation_policy_post_Type>,
  "400": HttpResponse<Any>,
  "401": HttpResponse<Any>,
  "402": HttpResponse<Any>,
  "403": HttpResponse<Any>,
  "429": HttpResponse<Any>,
  errorResponse: ResultFailure<O_escalation_policies_post_Type."400", Error<"400", "CLIENT_ERROR">> | ResultFailure<O_escalation_policies_post_Type."401", Error<"401", "CLIENT_ERROR">> | ResultFailure<O_escalation_policies_post_Type."402", Error<"402", "CLIENT_ERROR">> | ResultFailure<O_escalation_policies_post_Type."403", Error<"403", "CLIENT_ERROR">> | ResultFailure<O_escalation_policies_post_Type."429", Error<"429", "CLIENT_ERROR">> | ResultFailure<HttpResponse<Any>, UnexpectedError>,
  request: HttpRequestType<{| query: Object, headers: Object, cookie: Object, body?: { escalation_policy: { id?: String, summary?: String | Null, "type":
  String, self?: String | Null, html_url?: String | Null } & { "type": 
  "escalation_policy", name:
  String, description:
  String, num_loops?: 
  Integer, on_call_handoff_notifications?:
  "if_has_services" | "always", escalation_rules: Array<T_EscalationRule>, services?: Array<T_Reference>, teams?:
  Array<T_TeamReference> } } |}>,
  response: O_escalation_policies_post_Type."201"
}

var O_escalation_policies_post = {
  name: "CreateEscalationPolicy",
  displayName: "Create Escalation Policy",
  executor: (parameter: O_escalation_policies_post_Type.request, connection: HttpConnection): Result<O_escalation_policies_post_Type.response, O_escalation_policies_post_Type.errorResponse> -> do {
      var query = parameter.query default {} withSerializationConfig {}
      var headers = serializeHeaders(parameter.headers default {}, {})
      var cookie = serializeCookies(parameter.cookie default {}, {})
      var response = connection({
        method: "POST",
        path: "/escalation_policies",
        queryParams: query,
        headers: headers ++{"Accept": "application/json", "Content-Type":"application/json"},
        cookie: cookie,
        (body: parameter.body) if (parameter.body?)
      })
      ---
      response match {
        case response201 if response201.status == 201 -> success(response201 as O_escalation_policies_post_Type."201")
        case response400 if response400.status == 400 -> failure(response400, {
          kind: "400",
          categories: ["CLIENT_ERROR"]
        }, "Caller provided invalid arguments. Please review the response for error details. Retrying with the same arguments will *not* work.")
        case response401 if response401.status == 401 -> failure(response401, {
          kind: "401",
          categories: ["CLIENT_ERROR"]
        }, "Caller did not supply credentials or did not provide the correct credentials.\nIf you are using an API key, it may be invalid or your Authorization header may be malformed.\n")
        case response402 if response402.status == 402 -> failure(response402, {
          kind: "402",
          categories: ["CLIENT_ERROR"]
        }, "Account does not have the abilities to perform the action. Please review the response for the required abilities.\nYou can also use the [Abilities API](#resource_Abilities) to determine what features are available to your account.\n")
        case response403 if response403.status == 403 -> failure(response403, {
          kind: "403",
          categories: ["CLIENT_ERROR"]
        }, "Caller is not authorized to view the requested resource.\nWhile your authentication is valid, the authenticated user or token does not have permission to perform this action.\n")
        case response429 if response429.status == 429 -> failure(response429, {
          kind: "429",
          categories: ["CLIENT_ERROR"]
        }, "Too many requests have been made, the rate limit has been reached.")
        else responsedefault-> unexpectedFailure(responsedefault, {
          kind: response.status as String,
          categories: []
        })
      }
    }
}

