%dw 2.8

import Error, Result, ResultFailure, failure, unexpectedFailure, UnexpectedError, success from com::mulesoft::connectivity::Model

import Integer, LWDateTime from com::mulesoft::connectivity::Types

import Description, Label from com::mulesoft::connectivity::decorator::Annotations

import T_AddonReference, T_AlertGroupingParameters, T_AutoPauseNotificationsParameters, T_IncidentUrgencyRule, T_IntegrationReference, T_Reference, T_ScheduledAction, T_SupportHours, T_TeamReference from com::mulesoft::connectivity::pagerduty::types::Types

import HttpConnection, HttpRequestType, HttpResponse from com::mulesoft::connectivity::transport::Http

import serializeCookies, serializeHeaders, serializeUriParams, withSerializationConfig from com::mulesoft::connectivity::transport::Serialization

type service_put_Type = {
  "service": {
    id?: String,
    summary?: String | Null,
    "type"?: String,
    self?: String | Null,
    html_url?: String | Null,
    name?: String,
    description?: String | Null,
    auto_resolve_timeout?: Integer,
    acknowledgement_timeout?: Integer,
    created_at?: LWDateTime,
    updated_at?: LWDateTime | Null,
    status?: "active" | "warning" | "critical" | "maintenance" | "disabled",
    last_incident_timestamp?: LWDateTime | Null,
    escalation_policy?: T_Reference,
    response_play?: T_Reference  | Null,
    teams?: Array<T_TeamReference>,
    integrations?: Array<T_IntegrationReference>,
    incident_urgency_rule?: T_IncidentUrgencyRule,
    support_hours?: T_SupportHours | Null,
    scheduled_actions?: Array<T_ScheduledAction>,
    addons?: Array<T_AddonReference>,
    alert_creation?: "create_incidents" | "create_alerts_and_incidents",
    alert_grouping_parameters?: T_AlertGroupingParameters,
    alert_grouping?: "time" | "intelligent" | Null,
    alert_grouping_timeout?: Integer | Null,
    auto_pause_notifications_parameters?: T_AutoPauseNotificationsParameters
  }
}

type O_services__id__put_Type = {
  "200": HttpResponse<service_put_Type>,
  "401": HttpResponse<Any>,
  "402": HttpResponse<Any>,
  "403": HttpResponse<Any>,
  "404": HttpResponse<Any>,
  errorResponse: ResultFailure<O_services__id__put_Type."401", Error<"401", "CLIENT_ERROR">> |
                ResultFailure<O_services__id__put_Type."402", Error<"402", "CLIENT_ERROR">> |
                ResultFailure<O_services__id__put_Type."403", Error<"403", "CLIENT_ERROR">> |
                ResultFailure<O_services__id__put_Type."404", Error<"404", "CLIENT_ERROR">> |
                ResultFailure<HttpResponse<Any>, UnexpectedError>,
  request: HttpRequestType<{
    uri: { id: String },
    query: Object,
    headers: Object,
    cookie: Object,
    body?: {
      service: {
        id?: String,
        summary?: String | Null,
        "type"?: String,
        self?: String | Null,
        html_url?: String | Null,
        name?: String,
        description?: String | Null,
        auto_resolve_timeout?: Integer | Null,
        acknowledgement_timeout?: Integer | Null,
        created_at?: LWDateTime,
        status?: "active" | "warning" | "critical" | "maintenance" | "disabled",
        last_incident_timestamp?: LWDateTime,
        escalation_policy?: T_Reference,
        response_play?: T_Reference | Null,
        teams?: Array<T_TeamReference>,
        integrations?: Array<T_IntegrationReference>,
        incident_urgency_rule?: T_IncidentUrgencyRule | Null,
        support_hours?: T_SupportHours | Null,
        scheduled_actions?: Array<T_ScheduledAction>,
        addons?: Array<T_AddonReference>,
        alert_creation?: "create_incidents" | "create_alerts_and_incidents" | Null,
        alert_grouping_parameters?: T_AlertGroupingParameters | Null,
        alert_grouping?: "time" | "intelligent" | Null,
        alert_grouping_timeout?: Integer | Null,
        auto_pause_notifications_parameters?: T_AutoPauseNotificationsParameters | Null
      }
    }
  }>,
  response: O_services__id__put_Type."200"
}


var O_services__id__put = {
  name: "UpdateService",
  displayName: "Update Service",
  executor: (parameter: O_services__id__put_Type.request, connection: HttpConnection): Result<O_services__id__put_Type.response, O_services__id__put_Type.errorResponse> -> do {
      var uri = serializeUriParams(parameter.uri, {})
      var query = parameter.query default {} withSerializationConfig {}
      var headers = serializeHeaders(parameter.headers default {}, {})
      var cookie = serializeCookies(parameter.cookie default {}, {})
      var response = connection({
        method: "PUT",
        path: "/services/$(uri.id)",
        queryParams: query,
        headers: headers ++{"Accept": "application/json", "Content-Type":"application/json"},
        config: {
          contentType: "application/json"
        },
        cookie: cookie,
        (body: parameter.body) if (parameter.body?)
      })
      ---
      response match {
        case response200 if response200.status == 200 -> success(response200 as O_services__id__put_Type."200")
        case response401 if response401.status == 401 -> failure(response401, {
          kind: "401",
          categories: ["CLIENT_ERROR"]
        }, "Caller did not supply credentials or did not provide the correct credentials.\nIf you are using an API key, it may be invalid or your Authorization header may be malformed.\n")
        case response402 if response402.status == 402 -> failure(response402, {
          kind: "402",
          categories: ["CLIENT_ERROR"]
        }, "Account does not have the abilities to perform the action. Please review the response for the required abilities.\nYou can also use the [Abilities API](#resource_Abilities) to determine what features are available to your account.\n")
        case response403 if response403.status == 403 -> failure(response403, {
          kind: "403",
          categories: ["CLIENT_ERROR"]
        }, "Caller is not authorized to view the requested resource.\nWhile your authentication is valid, the authenticated user or token does not have permission to perform this action.\n")
        case response404 if response404.status == 404 -> failure(response404, {
          kind: "404",
          categories: ["CLIENT_ERROR"]
        }, "The requested resource was not found.")
        else responsedefault-> unexpectedFailure(responsedefault, {
          kind: response.status as String,
          categories: []
        })
      }
    }
}

