
%dw 2.5

import * from com::mulesoft::connectivity::pagerduty::operations::O_incidents_get
import * from com::mulesoft::connectivity::decorator::Operation
import * from com::mulesoft::connectivity::decorator::PaginationStrategies
import HttpRequestType from com::mulesoft::connectivity::transport::Http

// Paginated request type with offset-based pagination specific parameters (defined by user)
type O_incidents_get_paginated_Type = O_incidents_get_Type &{
  request: HttpRequestType<{|
    query: O_incidents_get_Type.request.query &{
      offset?: String,
      limit?: String
    }
  |}>
}

// Paginated operation, wrapped with offsetPaginated function (see com::mulesoft::connectivity::decorator::PaginationStrategies)
var O_incidents_get_paginated = offsetPaginated(
    O_incidents_get mapInputOperation (param: O_incidents_get_paginated_Type.request) -> param,
    (page) -> page.body.incidents default [],
    (param) -> param.query.offset default 0,
    (param, offsetValue) -> (param update { case query at .query! -> query update { case offset at .offset! -> offsetValue } })
)
