/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.parent.mojo;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class CommonsAbstractMojo extends AbstractMojo {

  @Parameter(readonly = true, defaultValue = "${project}")
  protected MavenProject project;

  @Override
  public void execute() throws MojoExecutionException, MojoFailureException {
    if (project.getPackaging().equalsIgnoreCase("mule-extension")) {
      doExecute();
    }
  }

  protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;
}
