/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.connection;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.sdk.api.annotation.param.RefName;

public abstract class RestConnectionProvider<C extends RestConnection>
implements CachedConnectionProvider<C>,
Startable,
Stoppable {
    static final String CLIENT_NAME_PATTERN = "rest.connector.%s";
    @RefName
    private String configName;
    @Inject
    private HttpService httpService;
    private HttpClient httpClient;

    public abstract String getBaseUri();

    public final C connect() throws ConnectionException {
        try {
            return this.createConnection(this.httpClient);
        }
        catch (Exception e) {
            throw new ConnectionException("Could not create connection", (Throwable)e);
        }
    }

    protected abstract C createConnection(HttpClient var1);

    public final void disconnect(C connection) {
    }

    public ConnectionValidationResult validate(C connection) {
        return ConnectionValidationResult.success();
    }

    public void start() {
        this.startHttpClient();
    }

    public void stop() {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }

    private void startHttpClient() {
        HttpClientConfiguration.Builder configuration = new HttpClientConfiguration.Builder().setName(String.format(CLIENT_NAME_PATTERN, this.configName));
        this.configureClient(configuration);
        this.httpClient = this.httpService.getClientFactory().create(configuration.build());
        this.httpClient.start();
    }

    protected void configureClient(HttpClientConfiguration.Builder httpConfiguration) {
    }
}

