/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.connection;

import org.mule.runtime.http.api.client.HttpClient;

public class DefaultRestConnection implements RestConnection {

  private final HttpClient httpClient;
  private final String baseUri;

  public DefaultRestConnection(HttpClient httpClient, String baseUri) {
    this.httpClient = httpClient;
    this.baseUri = baseUri;
  }

  public HttpClient getHttpClient() {
    return httpClient;
  }

  public String getBaseUri() {
    return baseUri;
  }


  // TODO - Proposal: Add a request method that receives a custom request builder as argument.
  // TODO - Proposal: This method could also handle exceptions and errors by default.

  // public CompletableFuture<HttpResponse> request(HttpRequestBuilder httpRequestBuilder){
  // return getHttpClient()
  // .sendAsync(
  // httpRequestBuilder.build(),
  // HttpRequestOptions.builder().followsRedirect(true).build());
  // }
}
