/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.metadata.input;

import org.mule.runtime.api.metadata.resolving.InputStaticTypeResolver;

public abstract class SchemaInputMetadataResolver extends InputStaticTypeResolver {

  @Override
  public String getResolverName() {
    return getClass().getName();
  }

  /**
   * Absolute path to the schema between the context of the owning connector. This path will be read using the
   * {@link Class#getResourceAsStream(String)} method
   *
   * @return the schema path inside the connector
   */
  protected abstract String getSchemaPath();

}
