/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.metadata.util;

import static org.mule.metadata.xml.api.SchemaCollector.getInstance;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.core.api.util.IOUtils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.function.Function;


public final class MetadataCommonUtils {

  private MetadataCommonUtils() {}

  public static MetadataType loadXmlSchema(ClassLoader classLoader, String schemaPath, String qName) {
    String schemaContent = readSchema(classLoader, schemaPath);
    URL schemaURL = classLoader.getResource(schemaPath);
    SchemaCollector schemaCollector =
        getInstance().addSchema(schemaURL.toString(), new ByteArrayInputStream(schemaContent.getBytes()));

    Optional<MetadataType> metadataType = new XmlTypeLoader(schemaCollector).load(qName);

    if (!metadataType.isPresent()) {
      throw new RuntimeException("Could not load XML Schema: " + schemaPath + " QName:" + qName);
    }

    return metadataType.get();
  }

  public static MetadataType loadJsonSchema(Function<String, TypeLoader> typeLoaderFactory, ClassLoader classLoader,
                                            String schemaPath, MetadataFormat metadataFormat) {
    String schemaContent = readSchema(classLoader, schemaPath);

    Optional<MetadataType> optionalMetadataType = typeLoaderFactory.apply(schemaContent).load(null);

    if (!optionalMetadataType.isPresent()) {
      throw new RuntimeException("Could not load Json Schema " + schemaPath);
    }

    return optionalMetadataType.get();
  }

  private static String readSchema(ClassLoader classLoader, String schemaPath) {
    try (InputStream in = classLoader.getResourceAsStream(schemaPath)) {
      if (in == null) {
        throw new IllegalArgumentException("Could not find schema at " + schemaPath);
      }
      return IOUtils.toString(in);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

}
