/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.metadata.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.function.Function;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.core.api.util.IOUtils;

public final class MetadataCommonUtils {
    private MetadataCommonUtils() {
    }

    public static MetadataType loadXmlSchema(ClassLoader classLoader, String schemaPath, String qName) {
        String schemaContent = MetadataCommonUtils.readSchema(classLoader, schemaPath);
        URL schemaURL = classLoader.getResource(schemaPath);
        SchemaCollector schemaCollector = SchemaCollector.getInstance().addSchema(schemaURL.toString(), (InputStream)new ByteArrayInputStream(schemaContent.getBytes()));
        Optional metadataType = new XmlTypeLoader(schemaCollector).load(qName);
        if (!metadataType.isPresent()) {
            throw new RuntimeException("Could not load XML Schema: " + schemaPath + " QName:" + qName);
        }
        return (MetadataType)metadataType.get();
    }

    public static MetadataType loadJsonSchema(Function<String, TypeLoader> typeLoaderFactory, ClassLoader classLoader, String schemaPath, MetadataFormat metadataFormat) {
        String schemaContent = MetadataCommonUtils.readSchema(classLoader, schemaPath);
        Optional optionalMetadataType = typeLoaderFactory.apply(schemaContent).load(null);
        if (!optionalMetadataType.isPresent()) {
            throw new RuntimeException("Could not load Json Schema " + schemaPath);
        }
        return (MetadataType)optionalMetadataType.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readSchema(ClassLoader classLoader, String schemaPath) {
        try (InputStream in = classLoader.getResourceAsStream(schemaPath);){
            if (in == null) {
                throw new IllegalArgumentException("Could not find schema at " + schemaPath);
            }
            String string = IOUtils.toString((InputStream)in);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

