/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.connection.basic;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.security.Username;

import com.mulesoft.connectivity.rest.commons.api.connection.DefaultRestConnection;

/**
 * Base abstract class that already defines the {@link org.mule.runtime.extension.api.annotation.param.Parameter} for supporting a
 * basic authentication connection provider.
 *
 * @since 1.0
 */
public abstract class BasicAuthenticationConnectionProvider
    extends BaseBasicAuthenticationConnectionProvider<DefaultRestConnection> {

  @Parameter
  @Summary("The username used to authenticate the requests.")
  @Username
  private String username;

  @Parameter
  @Optional
  @Summary("The password used to authenticate the requests.")
  @Password
  private String password;

  protected String getUsername() {
    return username;
  }

  protected String getPassword() {
    return password;
  }

}
