/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.connection.bearer;

import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.security.SecretToken;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;

/**
 * Base abstract class that already defines the {@link org.mule.runtime.extension.api.annotation.param.Parameter} for supporting a
 * bearer authentication connection provider.
 *
 * @since 1.0
 */
public abstract class BearerAuthenticationConnectionProvider
    extends BaseBearerAuthenticationConnectionProvider<BearerRestConnection> {

  @Parameter
  @Summary("The token used to authenticate the requests.")
  @SecretToken
  protected String token;

  @Override
  public String getToken() {
    return token;
  }

}
