/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.metadata;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.el.TypeBindings;

/**
 * Simplified version of Mule's {@link org.mule.runtime.api.metadata.ExpressionLanguageMetadataService} to allow Metadata type
 * resolvers to infer or resolve types based on already defined metadata type and Data Weave expressions.
 *
 * @since 1.0
 */
public interface ExpressionLanguageMetadataService {

  /**
   * Given the {@link MetadataType} and a DataWeave expression it will infer the resulting output type. The expression will be
   * invoked with a type binding by the name {@code payload} to access the type.
   *
   * @param type the {@link MetadataType}.
   * @param expression an expression.
   * @return the resolving output type after applying the DataWeave expression.
   */
  MetadataType getOutputType(MetadataType type, String expression);

  /**
   * Given the {@link TypeBindings} and a DataWeave expression it will infer the resulting output type.
   *
   * @param typeBindings the {@link TypeBindings}.
   * @param expression an expression.
   * @return the resolving output type after applying the DataWeave expression.
   */
  MetadataType getOutputType(TypeBindings typeBindings, String expression);

}
