/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadata;

import static com.mulesoft.connectivity.rest.commons.internal.util.FileUtils.readFile;
import static org.mule.metadata.xml.api.SchemaCollector.getInstance;
import static org.mule.runtime.api.util.Preconditions.checkArgument;
import static org.mule.runtime.core.api.util.StringUtils.isBlank;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;

import java.io.ByteArrayInputStream;
import java.net.URL;

public class ConnectivityXmlTypeLoader implements ConnectivityTypeLoader {

  private final String schemaPath;
  private final String qName;
  private final XmlTypeLoader typeLoader;

  public ConnectivityXmlTypeLoader(ClassLoader classLoader, String schemaPath, String qName) {
    checkArgument(classLoader != null, "classLoader cannot be null");
    checkArgument(!isBlank(schemaPath), "schemaPath cannot be blank");
    checkArgument(!isBlank(qName), "qName cannot be blank");

    this.schemaPath = schemaPath;
    this.qName = qName;
    String schemaContent = readFile(classLoader, schemaPath);
    URL schemaURL = classLoader.getResource(schemaPath);
    SchemaCollector schemaCollector =
        getInstance().addSchema(schemaURL.toString(), new ByteArrayInputStream(schemaContent.getBytes()));

    typeLoader = new XmlTypeLoader(schemaCollector);
  }

  public MetadataType load() {
    return typeLoader.load(qName)
        .orElseThrow(() -> new RuntimeException("Could not load XML Schema: " + schemaPath + " QName:" + qName));

  }

}
